/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomCreativeTab;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import java.util.List;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ItemAuraBottle
extends ItemImpl
implements IColorProvidingItem,
ICustomItemModel,
ICustomCreativeTab {
    public ItemAuraBottle(Item emptyBottle) {
        super("aura_bottle");
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
        DispenserBlock.registerBehavior((ItemLike)emptyBottle, (source, stack) -> {
            ItemStack bottle;
            ServerLevel level = source.level();
            BlockState state = source.state();
            Direction facing = (Direction)state.getValue((Property)DispenserBlock.FACING);
            BlockPos offset = source.pos().relative(facing);
            BlockState offsetState = level.getBlockState(offset);
            ItemStack dispense = stack.split(1);
            if (offsetState.isAir() && !(bottle = ItemAuraBottle.create((Level)level, offset)).isEmpty()) {
                dispense = bottle;
            }
            DefaultDispenseItemBehavior.spawnItem((Level)level, (ItemStack)dispense, (int)6, (Direction)facing, (Position)DispenserBlock.getDispensePosition((BlockSource)source));
            return stack;
        });
    }

    @Override
    public List<ItemStack> getCreativeTabItems() {
        return NaturesAuraAPI.AURA_TYPES.values().stream().map(t -> ItemAuraBottle.setType(new ItemStack((ItemLike)this), t)).toList();
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)(stack.getDescriptionId() + "." + String.valueOf(ItemAuraBottle.getType(stack).getName())));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, tintIndex) -> tintIndex > 0 ? FastColor.ARGB32.opaque((int)ItemAuraBottle.getType(stack).getColor()) : -1;
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "item/" + this.getBaseName())).texture("layer1", "item/" + this.getBaseName() + "_overlay");
    }

    public static IAuraType getType(ItemStack stack) {
        if (!stack.has(Data.TYPE)) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        String type = ((Data)stack.get(Data.TYPE)).auraType;
        if (type.isEmpty()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        return NaturesAuraAPI.AURA_TYPES.get(ResourceLocation.parse((String)type));
    }

    public static ItemStack setType(ItemStack stack, IAuraType type) {
        stack.set(Data.TYPE, (Object)new Data(type.getName().toString()));
        return stack;
    }

    private static ItemStack create(Level level, BlockPos pos) {
        int aura = IAuraChunk.getAuraInArea(level, pos, 30);
        if (aura <= -100000) {
            return new ItemStack((ItemLike)ModItems.VACUUM_BOTTLE);
        }
        if (aura >= 100000) {
            BlockPos spot = IAuraChunk.getHighestSpot(level, pos, 30, pos);
            IAuraChunk.getAuraChunk(level, spot).drainAura(spot, 20000);
            return ItemAuraBottle.setType(new ItemStack((ItemLike)ModItems.AURA_BOTTLE), IAuraType.forLevel(level));
        }
        return ItemStack.EMPTY;
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void onRightClick(PlayerInteractEvent.RightClickItem event) {
            ItemStack held = event.getItemStack();
            if (held.isEmpty() || held.getItem() != ModItems.BOTTLE_TWO_THE_REBOTTLING) {
                return;
            }
            Player player = event.getEntity();
            BlockHitResult ray = Item.getPlayerPOVHitResult((Level)player.level(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (ray.getType() == HitResult.Type.BLOCK) {
                return;
            }
            ItemStack bottle = ItemAuraBottle.create(player.level(), player.blockPosition());
            if (bottle.isEmpty()) {
                return;
            }
            if (!player.level().isClientSide) {
                held.shrink(1);
                if (!player.addItem(bottle)) {
                    player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), bottle));
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            player.swing(event.getHand());
        }
    }

    public record Data(String auraType) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("aura_type").forGetter(d -> d.auraType)).apply((Applicative)i, Data::new));
        public static final DataComponentType<Data> TYPE = DataComponentType.builder().persistent(CODEC).cacheEncoding().build();
    }
}

