/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.compat;

import dev.shadowsoffire.apothic_spawners.ASConfig;
import dev.shadowsoffire.apothic_spawners.ASObjects;
import dev.shadowsoffire.apothic_spawners.ApothicSpawners;
import dev.shadowsoffire.apothic_spawners.compat.SpawnerCategory;
import dev.shadowsoffire.apothic_spawners.modifiers.SpawnerModifier;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@JeiPlugin
public class SpawnerJEIPlugin
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration reg) {
        List<SpawnerModifier> recipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(ASObjects.SPAWNER_MODIFIER.get()).stream().sorted((r1, r2) -> -r1.id().compareNamespaced(r2.id())).map(RecipeHolder::value).toList();
        reg.addRecipes(SpawnerCategory.TYPE, recipes);
        if (ASConfig.spawnerSilkLevel == -1) {
            reg.addIngredientInfo((Object)new ItemStack((ItemLike)Blocks.SPAWNER), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{ApothicSpawners.lang("info", "spawner.no_silk", new Object[0])});
        } else if (ASConfig.spawnerSilkLevel == 0) {
            reg.addIngredientInfo((Object)new ItemStack((ItemLike)Blocks.SPAWNER), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{ApothicSpawners.lang("info", "always_drop", new Object[0])});
        } else {
            Minecraft.getInstance().level.holder(Enchantments.SILK_TOUCH).ifPresent(silk -> reg.addIngredientInfo((Object)new ItemStack((ItemLike)Blocks.SPAWNER), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{ApothicSpawners.lang("info", "spawner", ((MutableComponent)Enchantment.getFullname((Holder)silk, (int)ASConfig.spawnerSilkLevel)).withStyle(ChatFormatting.DARK_BLUE))}));
        }
        for (Item i : BuiltInRegistries.ITEM) {
            if (!(i instanceof SpawnEggItem)) continue;
            reg.addIngredientInfo((Object)new ItemStack((ItemLike)i), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{ApothicSpawners.lang("info", "capturing", ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(ASConfig.capturingDropChance * 100.0f))});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.SPAWNER), new RecipeType[]{SpawnerCategory.TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new SpawnerCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public ResourceLocation getPluginUid() {
        return ApothicSpawners.loc("spawner");
    }
}

