/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.rules;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.utils.rules.CoreRules;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.core.utils.rules.IRuleType;

public record FuzzyBlockStateRule(Block block, Map<String, Property.Value<?>> propertyMap) implements IRule
{
    public static final MapCodec<FuzzyBlockStateRule> CODEC = BuiltInRegistries.BLOCK.byNameCodec().dispatchMap("block", rule -> rule.block, blockType -> FuzzyBlockStateRule.blockPropertiesOf(blockType).xmap(propMap -> new FuzzyBlockStateRule((Block)blockType, (Map<String, Property.Value<?>>)propMap), pred -> pred.propertyMap).optionalFieldOf("properties").xmap(op -> op.orElseGet(() -> new FuzzyBlockStateRule((Block)blockType, Collections.emptyMap())), pred -> pred.propertyMap.isEmpty() ? Optional.empty() : Optional.of(pred)));

    public static FuzzyBlockStateRule of(BlockState stateTemplate, Property<?> ... properties) {
        HashMap map = Arrays.stream(properties).collect(Collectors.toMap(Property::getName, property -> property.value((StateHolder)stateTemplate), (a, b) -> b, HashMap::new));
        return new FuzzyBlockStateRule(stateTemplate.getBlock(), map);
    }

    @Override
    public boolean matches(BlockState state) {
        if (state.getBlock() != this.block) {
            return false;
        }
        for (Map.Entry<String, Property.Value<?>> propEntry : this.propertyMap.entrySet()) {
            Property.Value<?> value = propEntry.getValue();
            if (Objects.equals(value.value(), value.property().value((StateHolder)state).value())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public IRuleType<?> getType() {
        return (IRuleType)CoreRules.RuleFuzzyBlockState.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FuzzyBlockStateRule)) return false;
        FuzzyBlockStateRule rule = (FuzzyBlockStateRule)obj;
        if (this.block != rule.block) return false;
        if (!this.propertyMap.equals(rule.propertyMap)) return false;
        return true;
    }

    static Codec<Map<String, Property.Value<?>>> blockPropertiesOf(Block block) {
        MapCodec mapcodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(HashMap::new));
        BlockState baseState = block.defaultBlockState();
        for (Property property : baseState.getProperties()) {
            mapcodec = Codec.mapPair((MapCodec)mapcodec, (MapCodec)property.valueCodec().optionalFieldOf(property.getName())).xmap(thePair -> {
                Optional optionalProperty = (Optional)thePair.getSecond();
                if (optionalProperty.isPresent()) {
                    Property.Value value = (Property.Value)optionalProperty.get();
                    ((Map)thePair.getFirst()).put(value.property().getName(), value);
                }
                return (Map)thePair.getFirst();
            }, theMap -> Pair.of((Object)theMap, Optional.ofNullable((Property.Value)theMap.get(property.getName()))));
        }
        return mapcodec.codec();
    }
}

