/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.systems;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import tv.soaryn.xycraft.core.content.attachments.accessors.Ticks;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.LevelSystemBase;

public abstract class ServerBlockTickSystem<TData extends BlockTickSystemLevelAttachment>
extends LevelSystemBase<TData> {
    @Override
    public void postTick(LevelTickEvent event, TData data) {
        ServerLevel serverLevel;
        super.postTick(event, data);
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel) || !(serverLevel = (ServerLevel)level).tickRateManager().runsNormally()) {
            return;
        }
        ProfilerFiller profiler = serverLevel.getProfiler();
        profiler.push(this.getName());
        long tick = Ticks.of((IAttachmentHolder)serverLevel);
        long frequency = ((BlockTickSystemLevelAttachment)data).frequency();
        this.tickSystem(serverLevel, data, tick);
        LongArraySet invalidPositions = new LongArraySet();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (Long2ObjectMap.Entry entry : ((BlockTickSystemLevelAttachment)data).ChunkMap.long2ObjectEntrySet()) {
            invalidPositions.clear();
            if (!serverLevel.shouldTickBlocksAt(entry.getLongKey())) continue;
            LongIterator it = ((LongArraySet)entry.getValue()).longIterator();
            while (it.hasNext()) {
                long posId = it.nextLong();
                blockPos.set(posId);
                BlockState state = serverLevel.getBlockState((BlockPos)blockPos);
                if (!this.isValidState(serverLevel, state, (BlockPos)blockPos)) {
                    invalidPositions.add(posId);
                    continue;
                }
                this.tickBlocks(serverLevel, data, blockPos, state, tick);
                if ((posId + tick) % frequency != 0L) continue;
                this.tickBatchBlocks(serverLevel, data, blockPos, state, tick);
            }
            this.handleCleanPositions(serverLevel, invalidPositions);
        }
        profiler.pop();
    }

    private void handleCleanPositions(ServerLevel serverLevel, LongArraySet invalidPositions) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (long posId : invalidPositions.toLongArray()) {
            mutablePos.set(posId);
            this.clean(serverLevel, mutablePos);
        }
    }

    public void add(ServerLevel level, BlockPos pos) {
        BlockTickSystemLevelAttachment data = (BlockTickSystemLevelAttachment)this.getData((Level)level);
        long posId = pos.asLong();
        long chunkId = ChunkPos.asLong((BlockPos)pos);
        LongArraySet posMap = (LongArraySet)data.ChunkMap.computeIfAbsent(chunkId, aLong -> new LongArraySet());
        if (posMap.contains(posId)) {
            return;
        }
        posMap.add(posId);
    }

    public void remove(ServerLevel level, BlockPos pos) {
        BlockTickSystemLevelAttachment data = (BlockTickSystemLevelAttachment)this.getData((Level)level);
        long posId = pos.asLong();
        long chunkId = ChunkPos.asLong((BlockPos)pos);
        LongArraySet remainingPositions = (LongArraySet)data.ChunkMap.computeIfPresent(chunkId, (id, positions) -> {
            positions.remove(posId);
            return positions;
        });
        if (remainingPositions == null || remainingPositions.isEmpty()) {
            data.ChunkMap.remove(chunkId);
        }
    }

    public abstract boolean isValidState(ServerLevel var1, BlockState var2, BlockPos var3);

    public abstract void clean(ServerLevel var1, BlockPos.MutableBlockPos var2);

    protected void tickSystem(ServerLevel level, TData tickData, long currentStep) {
    }

    protected void tickBlocks(ServerLevel level, TData tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
    }

    protected void tickBatchBlocks(ServerLevel level, TData tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
    }
}

