/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.systems.LevelSystemBase;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;

public class XyBlock
extends Block {
    protected DeferredHolder<LevelSystemBase<?>, ? extends ServerBlockTickSystem<?>> _system = null;
    private boolean hasCapability;

    public XyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public String getToolTipKey() {
        return this.getDescriptionId() + ".tooltip";
    }

    public String getToolTipKey(int i) {
        return this.getToolTipKey() + "." + i;
    }

    protected <T extends ServerBlockTickSystem<?>> void registerSystem(DeferredHolder<LevelSystemBase<?>, T> system) {
        this._system = system;
    }

    protected void registerHasCapability() {
        this.hasCapability = true;
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean p_54758_) {
        if (this._system != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((ServerBlockTickSystem)this._system.get()).add(serverLevel, pos);
        }
        if (this.hasCapability) {
            level.invalidateCapabilities(pos);
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onRemove(state, level, pos, oldState, moving);
        if (this._system != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((ServerBlockTickSystem)this._system.get()).remove(serverLevel, pos);
        }
        if (this.hasCapability) {
            level.invalidateCapabilities(pos);
        }
    }

    public static void clean(Block block, ServerLevel level, BlockPos.MutableBlockPos pos) {
        if (block instanceof XyBlock) {
            XyBlock xyBlock = (XyBlock)block;
            xyBlock.cleanRemove(level, (BlockPos)pos);
        }
    }

    protected void cleanRemove(ServerLevel level, BlockPos pos) {
        if (this._system != null) {
            ((ServerBlockTickSystem)this._system.get()).remove(level, pos);
        }
        if (this.hasCapability) {
            level.invalidateCapabilities(pos);
        }
    }

    public void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource randSource) {
        if (this._system != null) {
            ((ServerBlockTickSystem)this._system.get()).add(level, pos);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltips, flag);
        XyBlock xyBlock = this;
        if (xyBlock instanceof ITooltipProvider) {
            ITooltipProvider tooltipProvider = (ITooltipProvider)((Object)xyBlock);
            tooltipProvider.appendToolTip(stack, context, tooltips, flag);
        }
        if (FeatureFlags.isExperimental((FeatureFlagSet)this.requiredFeatures())) {
            tooltips.add((Component)XyCore.Experimental.copy().withColor(-3399134));
        }
    }

    public static abstract class WithEntity
    extends XyBlock
    implements EntityBlock {
        private final BiFunction<BlockPos, BlockState, XyBlockEntity> entityType;

        public WithEntity(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, XyBlockEntity> entityType) {
            super(properties);
            this.entityType = entityType;
        }

        @Nullable
        public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
            return this.entityType.apply(pos, state);
        }
    }
}

