/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.item.ItemContainer;

public class SimpleItemContainer
implements ItemContainer {
    private final NonNullList<ItemStack> items;
    @Nullable
    private final Runnable updateCallback;

    public SimpleItemContainer() {
        this(1);
    }

    public SimpleItemContainer(int size, @Nullable Runnable updateCallback) {
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.updateCallback = updateCallback;
    }

    public SimpleItemContainer(int size) {
        this(size, null);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    @NotNull
    public ItemStack get(int slot) {
        Objects.checkIndex(slot, this.size());
        return (ItemStack)this.items.get(slot);
    }

    @Override
    public void set(int slot, @NotNull ItemStack stack) {
        Objects.checkIndex(slot, this.size());
        this.items.set(slot, (Object)stack);
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    public boolean isValid(int slot, @NotNull ItemStack stack) {
        Objects.checkIndex(slot, this.size());
        return true;
    }

    @Override
    public void clear() {
        Collections.fill(this.items, ItemStack.EMPTY);
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    @NotNull
    public ItemContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new Slice(from, to - from);
    }

    public static SimpleItemContainer from(NonNullList<ItemStack> items) {
        SimpleItemContainer inventory = new SimpleItemContainer(items.size());
        for (int i = 0; i < items.size(); ++i) {
            inventory.set(i, ((ItemStack)items.get(i)).copy());
        }
        return inventory;
    }

    private class Slice
    implements ItemContainer {
        private final int start;
        private final int length;

        public Slice(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        @NotNull
        public ItemStack get(int slot) {
            Objects.checkIndex(slot, this.length);
            return SimpleItemContainer.this.get(slot + this.start);
        }

        @Override
        public void set(int slot, @NotNull ItemStack stack) {
            Objects.checkIndex(slot, this.length);
            SimpleItemContainer.this.set(slot + this.start, stack);
        }

        @Override
        public boolean isValid(int slot, @NotNull ItemStack stack) {
            Objects.checkIndex(slot, this.length);
            return SimpleItemContainer.this.isValid(slot + this.start, stack);
        }

        @Override
        public int getSlotCapacity(int slot) {
            return SimpleItemContainer.this.getSlotCapacity(slot + this.start);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.length; ++i) {
                SimpleItemContainer.this.items.set(i + this.start, (Object)ItemStack.EMPTY);
            }
            if (SimpleItemContainer.this.updateCallback != null) {
                SimpleItemContainer.this.updateCallback.run();
            }
        }

        @Override
        @NotNull
        public ItemContainer slice(int from, int to) {
            Objects.checkFromToIndex(from, to, this.length);
            return new Slice(this.start + from, to - from);
        }
    }
}

