/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.items;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import de.keksuccino.konkrete.input.MouseInput;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class FoodItem {
    public static final ResourceLocation TEXTURE_FOOD = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/buddy/food.png");
    public int x;
    public int y;
    public boolean isDragged = false;
    public int lifetime = 600;
    public final int size = 16;
    public boolean stickToCursor = false;
    public boolean justCreated = true;
    public final Buddy buddy;

    public FoodItem(int x, int y, Buddy buddy) {
        this.x = x;
        this.y = y;
        this.buddy = buddy;
    }

    public void render(GuiGraphics graphics) {
        graphics.blit(TEXTURE_FOOD, this.x - 8, this.y - 8, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public void tick() {
        this.justCreated = false;
        --this.lifetime;
        if (!this.isDragged && !this.stickToCursor) {
            ++this.y;
            if (this.y > this.buddy.getScreenHeight()) {
                this.lifetime = 0;
            }
        } else if (this.stickToCursor) {
            this.x = MouseInput.getMouseX();
            this.y = MouseInput.getMouseY();
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x - 8) && mouseX < (double)(this.x + 8) && mouseY >= (double)(this.y - 8) && mouseY < (double)(this.y + 8);
    }

    public void pickup(int mouseX, int mouseY) {
        if (this.justCreated) {
            return;
        }
        this.setBeingDragged(true);
        this.x = mouseX;
        this.y = mouseY;
    }

    public void drop(int mouseX, int mouseY) {
        if (this.justCreated) {
            return;
        }
        this.setBeingDragged(false);
        this.x = mouseX;
        this.y = mouseY;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean isBeingDragged() {
        return this.isDragged;
    }

    public void setBeingDragged(boolean dragged) {
        this.isDragged = dragged;
    }

    public boolean shouldRemove() {
        return this.lifetime <= 0;
    }

    public boolean isNearBuddy(int buddyX, int buddyY) {
        int dx = this.x - buddyX;
        int dy = this.y - buddyY;
        return Math.sqrt(dx * dx + dy * dy) < 40.0;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

