/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.layers;

import io.wispforest.owo.mixin.ui.layers.HandledScreenAccessor;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.util.pond.OwoScreenExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Layer<S extends Screen, R extends ParentComponent> {
    protected final BiFunction<Sizing, Sizing, R> rootComponentMaker;
    protected final Consumer<Instance> instanceInitializer;

    protected Layer(BiFunction<Sizing, Sizing, R> rootComponentMaker, Consumer<Instance> instanceInitializer) {
        this.rootComponentMaker = rootComponentMaker;
        this.instanceInitializer = instanceInitializer;
    }

    public Instance instantiate(S screen) {
        return new Instance(this, screen);
    }

    public Instance getInstance(S screen) {
        return ((OwoScreenExtension)screen).owo$getInstance(this);
    }

    public class Instance {
        public final S screen;
        public final OwoUIAdapter<R> adapter;
        public boolean aggressivePositioning = false;
        protected final List<Runnable> layoutUpdaters = new ArrayList<Runnable>();

        protected Instance(S screen) {
            this.screen = screen;
            this.adapter = OwoUIAdapter.createWithoutScreen(0, 0, ((Screen)screen).width, ((Screen)screen).height, this$0.rootComponentMaker);
            this$0.instanceInitializer.accept(this);
        }

        @ApiStatus.Internal
        public void resize(int width, int height) {
            this.adapter.moveAndResize(0, 0, width, height);
        }

        @Nullable
        public AbstractWidget queryWidget(Predicate<AbstractWidget> locator) {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            for (GuiEventListener element : this.screen.children()) {
                Instance.collectChildren(element, widgets);
            }
            AbstractWidget widget = null;
            for (AbstractWidget candidate : widgets) {
                if (!locator.test(candidate)) continue;
                widget = candidate;
                break;
            }
            return widget;
        }

        public void alignComponentToWidget(Predicate<AbstractWidget> locator, AnchorSide anchor, float justification, Component component) {
            this.layoutUpdaters.add(() -> {
                AbstractWidget widget = this.queryWidget(locator);
                if (widget == null) {
                    component.positioning(Positioning.absolute(0, 0));
                    return;
                }
                Size size = component.fullSize();
                switch (anchor.ordinal()) {
                    case 0: {
                        component.positioning(Positioning.absolute((int)((float)widget.getX() + (float)(widget.getWidth() - size.width()) * justification), widget.getY() - size.height()));
                        break;
                    }
                    case 3: {
                        component.positioning(Positioning.absolute(widget.getX() + widget.getWidth(), (int)((float)widget.getY() + (float)(widget.getHeight() - size.height()) * justification)));
                        break;
                    }
                    case 1: {
                        component.positioning(Positioning.absolute((int)((float)widget.getX() + (float)(widget.getWidth() - size.width()) * justification), widget.getY() + widget.getHeight()));
                        break;
                    }
                    case 2: {
                        component.positioning(Positioning.absolute(widget.getX() - size.width(), (int)((float)widget.getY() + (float)(widget.getHeight() - size.height()) * justification)));
                    }
                }
            });
        }

        public void alignComponentToHandledScreenCoordinates(Component component, int x, int y) {
            Object s = this.screen;
            if (!(s instanceof AbstractContainerScreen)) {
                throw new IllegalStateException("Handled screen coordinates only exist on screens which extend HandledScreen<?>");
            }
            AbstractContainerScreen handledScreen = (AbstractContainerScreen)s;
            this.layoutUpdaters.add(() -> component.positioning(Positioning.absolute(((HandledScreenAccessor)handledScreen).owo$getRootX() + x, ((HandledScreenAccessor)handledScreen).owo$getRootY() + y)));
        }

        @ApiStatus.Internal
        public void dispatchLayoutUpdates() {
            this.layoutUpdaters.forEach(Runnable::run);
        }

        private static void collectChildren(GuiEventListener element, List<AbstractWidget> children) {
            if (element instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)element;
                children.add(widget);
            }
            if (element instanceof Layout) {
                Layout layout = (Layout)element;
                layout.visitWidgets(child -> Instance.collectChildren((GuiEventListener)child, children));
            }
        }

        public static enum AnchorSide {
            TOP,
            BOTTOM,
            LEFT,
            RIGHT;

        }
    }
}

