/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.w3c.dom.Element;

public class SliderComponent
extends AbstractSliderButton {
    protected final EventStream<OnChanged> changedEvents = OnChanged.newStream();
    protected final EventStream<OnSlideEnd> slideEndEvents = OnSlideEnd.newStream();
    protected Function<String, Component> messageProvider = value -> Component.empty();
    protected double scrollStep = 0.05;

    protected SliderComponent(Sizing horizontalSizing) {
        super(0, 0, 0, 0, (Component)Component.empty(), 0.0);
        this.sizing(horizontalSizing, Sizing.fixed(20));
    }

    public SliderComponent value(double value) {
        if (this.value != (value = Mth.clamp((double)value, (double)0.0, (double)1.0))) {
            this.value = value;
            this.updateMessage();
            this.applyValue();
        }
        return this;
    }

    public double value() {
        return this.value;
    }

    public SliderComponent message(Function<String, Component> messageProvider) {
        this.messageProvider = messageProvider;
        this.updateMessage();
        return this;
    }

    public SliderComponent scrollStep(double scrollStep) {
        this.scrollStep = scrollStep;
        return this;
    }

    public double scrollStep() {
        return this.scrollStep;
    }

    public SliderComponent active(boolean active) {
        this.active = active;
        return this;
    }

    public boolean active() {
        return this.active;
    }

    public EventSource<OnChanged> onChanged() {
        return this.changedEvents.source();
    }

    public EventSource<OnSlideEnd> slideEnd() {
        return this.slideEndEvents.source();
    }

    protected void updateMessage() {
        this.setMessage(this.messageProvider.apply(String.valueOf(this.value)));
    }

    protected void applyValue() {
        this.changedEvents.sink().onChanged(this.value);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        if (!this.active) {
            return super.onMouseScroll(mouseX, mouseY, amount);
        }
        this.value(this.value + this.scrollStep * amount);
        super.onMouseScroll(mouseX, mouseY, amount);
        return true;
    }

    public boolean onMouseUp(double mouseX, double mouseY, int button) {
        this.slideEndEvents.sink().onSlideEnd();
        return super.onMouseUp(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.active) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean isValidClickButton(int button) {
        return this.active && super.isValidClickButton(button);
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        if (children.containsKey("text")) {
            Element node = children.get("text");
            String content = node.getTextContent().strip();
            if (node.getAttribute("translate").equalsIgnoreCase("true")) {
                this.message(value -> Component.translatable((String)content, (Object[])new Object[]{value}));
            } else {
                MutableComponent text = Component.literal((String)content);
                this.message(value -> text);
            }
        }
        UIParsing.apply(children, "value", UIParsing::parseDouble, this::value);
    }

    @Deprecated
    public final void setMessage(Component message) {
        super.setMessage(message);
    }

    public static interface OnChanged {
        public void onChanged(double var1);

        public static EventStream<OnChanged> newStream() {
            return new EventStream<OnChanged>(subscribers -> value -> {
                for (OnChanged subscriber : subscribers) {
                    subscriber.onChanged(value);
                }
            });
        }
    }

    public static interface OnSlideEnd {
        public void onSlideEnd();

        public static EventStream<OnSlideEnd> newStream() {
            return new EventStream<OnSlideEnd>(subscribers -> () -> {
                for (OnSlideEnd subscriber : subscribers) {
                    subscriber.onSlideEnd();
                }
            });
        }
    }
}

