/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import io.wispforest.owo.itemgroup.json.WrapperGroup;
import io.wispforest.owo.moddata.ModDataConsumer;
import io.wispforest.owo.util.pond.OwoItemExtensions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.callback.AddCallback;
import net.neoforged.neoforge.registries.callback.RegistryCallback;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class OwoItemGroupLoader
implements ModDataConsumer {
    public static final OwoItemGroupLoader INSTANCE = new OwoItemGroupLoader();
    private static final Map<ResourceLocation, JsonObject> BUFFERED_GROUPS = new HashMap<ResourceLocation, JsonObject>();

    private OwoItemGroupLoader() {
    }

    public static void onGroupCreated(CreativeModeTab group) {
        ResourceLocation groupId = BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)group);
        if (!BUFFERED_GROUPS.containsKey(groupId)) {
            return;
        }
        INSTANCE.acceptParsedFile(groupId, BUFFERED_GROUPS.remove(groupId));
    }

    @Override
    public void acceptParsedFile(ResourceLocation id, JsonObject json) {
        ResourceLocation targetGroupId = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"target_group"));
        CreativeModeTab searchGroup = null;
        for (CreativeModeTab group : CreativeModeTabs.allTabs()) {
            if (!BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)group).equals((Object)targetGroupId)) continue;
            searchGroup = group;
            break;
        }
        if (searchGroup == null) {
            BUFFERED_GROUPS.put(targetGroupId, json);
            return;
        }
        CreativeModeTab targetGroup = searchGroup;
        JsonArray tabsArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"tabs", (JsonArray)new JsonArray());
        ArrayList<ItemGroupTab> tabs = new ArrayList<ItemGroupTab>();
        tabsArray.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject tabObject = jsonElement.getAsJsonObject();
            ResourceLocation texture = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)tabObject, (String)"texture", (String)ItemGroupTab.DEFAULT_TEXTURE.toString()));
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)tabObject, (String)"tag")));
            Item icon = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)tabObject, (String)"icon")));
            String name = GsonHelper.getAsString((JsonObject)tabObject, (String)"name");
            tabs.add(new ItemGroupTab(Icon.of((ItemLike)icon), OwoItemGroup.ButtonDefinition.tooltipFor(targetGroup, "tab", name), (context, entries) -> BuiltInRegistries.ITEM.stream().filter(item -> item.builtInRegistryHolder().is(tag)).forEach(arg_0 -> ((CreativeModeTab.Output)entries).accept(arg_0)), texture, false));
        });
        JsonArray buttonsArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"buttons", (JsonArray)new JsonArray());
        ArrayList<ItemGroupButton> buttons = new ArrayList<ItemGroupButton>();
        buttonsArray.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject buttonObject = jsonElement.getAsJsonObject();
            String link = GsonHelper.getAsString((JsonObject)buttonObject, (String)"link");
            String name = GsonHelper.getAsString((JsonObject)buttonObject, (String)"name");
            int u = GsonHelper.getAsInt((JsonObject)buttonObject, (String)"texture_u");
            int v = GsonHelper.getAsInt((JsonObject)buttonObject, (String)"texture_v");
            int textureWidth = GsonHelper.getAsInt((JsonObject)buttonObject, (String)"texture_width", (int)64);
            int textureHeight = GsonHelper.getAsInt((JsonObject)buttonObject, (String)"texture_height", (int)64);
            String textureId = GsonHelper.getAsString((JsonObject)buttonObject, (String)"texture", null);
            ResourceLocation texture = textureId == null ? ItemGroupButton.ICONS_TEXTURE : ResourceLocation.parse((String)textureId);
            buttons.add(ItemGroupButton.link(targetGroup, Icon.of(texture, u, v, textureWidth, textureHeight), name, link));
        });
        if (targetGroup instanceof WrapperGroup) {
            WrapperGroup wrapper = (WrapperGroup)targetGroup;
            wrapper.addTabs(tabs);
            wrapper.addButtons(buttons);
            if (GsonHelper.getAsBoolean((JsonObject)json, (String)"extend", (boolean)false)) {
                wrapper.markExtension();
            }
        } else {
            WrapperGroup wrapper = new WrapperGroup(targetGroup, targetGroupId, tabs, buttons);
            wrapper.initialize();
            if (GsonHelper.getAsBoolean((JsonObject)json, (String)"extend", (boolean)false)) {
                wrapper.markExtension();
            }
            BuiltInRegistries.ITEM.stream().filter(item -> ((OwoItemExtensions)item).owo$group() == targetGroup).forEach(item -> ((OwoItemExtensions)item).owo$setGroup(() -> wrapper));
        }
    }

    @Override
    public String getDataSubdirectory() {
        return "item_group_tabs";
    }

    public static void initItemGroupCallback() {
        BuiltInRegistries.CREATIVE_MODE_TAB.addCallback((RegistryCallback)((AddCallback)(registry, rawId, id, group) -> OwoItemGroupLoader.onGroupCreated(group)));
    }
}

