/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.KeyBindings;
import com.direwolf20.justdirethings.common.items.PortalGunV2;
import com.direwolf20.justdirethings.common.network.data.PortalGunFavoriteChangePayload;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.NBTHelpers;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class AdvPortalEditMenu
extends Screen {
    private int slotSelected = 0;
    private int ticksOpened = 0;
    private ItemStack portalGun;
    private EditBox nameField;
    private EditBox xPos;
    private EditBox yPos;
    private EditBox zPos;
    private final Predicate<String> doubleInputValidator = this::isValidDoubleInput;

    protected AdvPortalEditMenu(ItemStack itemStack, int favoritePosition) {
        super((Component)Component.literal((String)""));
        this.portalGun = itemStack;
        this.slotSelected = favoritePosition;
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public void init() {
        super.init();
        int n = this.width / 2 - 75;
        int n2 = this.height / 2 - 34;
        Objects.requireNonNull(this.font);
        this.nameField = new EditBox(this.font, n, n2, 200, 9 + 3, (Component)Component.translatable((String)"buildinggadgets2.screen.namefieldtext"));
        int n3 = this.width / 2 - 75;
        int n4 = this.height / 2 - 20;
        Objects.requireNonNull(this.font);
        this.xPos = new EditBox(this.font, n3, n4, 60, 9 + 3, (Component)Component.translatable((String)"buildinggadgets2.screen.namefieldtext"));
        int n5 = this.width / 2 - 5;
        int n6 = this.height / 2 - 20;
        Objects.requireNonNull(this.font);
        this.yPos = new EditBox(this.font, n5, n6, 60, 9 + 3, (Component)Component.translatable((String)"buildinggadgets2.screen.namefieldtext"));
        int n7 = this.width / 2 + 65;
        int n8 = this.height / 2 - 20;
        Objects.requireNonNull(this.font);
        this.zPos = new EditBox(this.font, n7, n8, 60, 9 + 3, (Component)Component.translatable((String)"buildinggadgets2.screen.namefieldtext"));
        this.updateNameField();
        ExtendedButton buttonSave = new ExtendedButton(this.width / 2 - 75, this.height / 2, 120, 16, (Component)Component.translatable((String)"justdirethings.screen.save_close"), button -> this.addFavorite());
        this.addRenderableWidget((GuiEventListener)buttonSave);
        ExtendedButton buttonCancel = new ExtendedButton(this.width / 2 + 60, this.height / 2, 65, 16, (Component)Component.translatable((String)"justdirethings.screen.cancel"), button -> this.onClose());
        this.addRenderableWidget((GuiEventListener)buttonCancel);
        this.nameField.setMaxLength(15);
        this.nameField.setVisible(true);
        this.addRenderableWidget((GuiEventListener)this.nameField);
        this.xPos.setVisible(true);
        this.xPos.setFilter(this.doubleInputValidator);
        this.xPos.setEditable(false);
        this.addRenderableWidget((GuiEventListener)this.xPos);
        this.yPos.setVisible(true);
        this.yPos.setFilter(this.doubleInputValidator);
        this.yPos.setEditable(false);
        this.addRenderableWidget((GuiEventListener)this.yPos);
        this.zPos.setVisible(true);
        this.zPos.setFilter(this.doubleInputValidator);
        this.zPos.setEditable(false);
        this.addRenderableWidget((GuiEventListener)this.zPos);
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.nameField);
    }

    public void render(GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        super.render(guiGraphics, mx, my, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.ticksOpened < 400 && p_keyPressed_1_ == KeyBindings.toggleTool.getKey().getValue()) {
            return true;
        }
        if (p_keyPressed_1_ == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void tick() {
        ++this.ticksOpened;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        String toggleToolKeybind = KeyBindings.toggleTool.getKey().getName();
        if (this.ticksOpened < 20 && toggleToolKeybind.charAt(toggleToolKeybind.length() - 1) == pCodePoint) {
            return false;
        }
        return this.getFocused() != null && this.getFocused().charTyped(pCodePoint, pModifiers);
    }

    public void addFavorite() {
        try {
            NBTHelpers.PortalDestination portalDestination = PortalGunV2.getFavorite(this.portalGun, this.slotSelected);
            if (portalDestination == null || portalDestination.equals(NBTHelpers.PortalDestination.EMPTY)) {
                LocalPlayer player = Minecraft.getInstance().player;
                Vec3 position = player.position();
                Direction facing = MiscHelpers.getFacingDirection((Player)player);
                portalDestination = new NBTHelpers.PortalDestination(new NBTHelpers.GlobalVec3((ResourceKey<Level>)player.level().dimension(), position), facing, "UNNAMED");
            }
            Vec3 coords = portalDestination.globalVec3().position();
            PacketDistributor.sendToServer((CustomPacketPayload)new PortalGunFavoriteChangePayload(this.slotSelected, true, this.nameField.getValue(), true, coords), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        }
        catch (NumberFormatException e) {
            System.out.println("Error: Invalid format for the validFormattedX string");
        }
    }

    public void updateNameField() {
        NBTHelpers.PortalDestination portalDestination = PortalGunV2.getFavorite(this.portalGun, this.slotSelected);
        LocalPlayer player = Minecraft.getInstance().player;
        if (portalDestination == null || portalDestination.equals(NBTHelpers.PortalDestination.EMPTY)) {
            Vec3 position = player.position();
            Direction facing = MiscHelpers.getFacingDirection((Player)player);
            portalDestination = new NBTHelpers.PortalDestination(new NBTHelpers.GlobalVec3((ResourceKey<Level>)player.level().dimension(), position), facing, "UNNAMED");
        }
        String favoriteName = portalDestination.name();
        this.nameField.setValue(favoriteName);
        Vec3 coords = portalDestination.globalVec3().position();
        this.xPos.setValue(String.format("%.2f", coords.x));
        this.yPos.setValue(String.format("%.2f", coords.y));
        this.zPos.setValue(String.format("%.2f", coords.z));
    }

    private boolean isValidDoubleInput(String input) {
        if (input.isEmpty()) {
            return true;
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

