/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.command.GenerateModelCommand;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GiveModelCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_MODEL_TIER = (ctx, builder) -> SharedSuggestionProvider.suggest(ModelTierRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::getPath), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"give_model").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"model", (ArgumentType)ResourceLocationArgument.id()).suggests(GenerateModelCommand.SUGGEST_DATA_MODEL).then(((RequiredArgumentBuilder)Commands.argument((String)"tier", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_MODEL_TIER).executes(c -> GiveModelCommand.giveItem((CommandSourceStack)c.getSource(), ResourceLocationArgument.getId((CommandContext)c, (String)"model"), EntityArgument.getPlayers((CommandContext)c, (String)"targets"), StringArgumentType.getString((CommandContext)c, (String)"tier"), 0))).then(Commands.argument((String)"data", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> GiveModelCommand.giveItem((CommandSourceStack)c.getSource(), ResourceLocationArgument.getId((CommandContext)c, (String)"model"), EntityArgument.getPlayers((CommandContext)c, (String)"targets"), StringArgumentType.getString((CommandContext)c, (String)"tier"), IntegerArgumentType.getInteger((CommandContext)c, (String)"data"))))))));
    }

    private static int giveItem(CommandSourceStack pSource, ResourceLocation modelId, Collection<ServerPlayer> pTargets, String tierName, int bonusData) throws CommandSyntaxException {
        DataModel model = (DataModel)DataModelRegistry.INSTANCE.getValue(modelId);
        if (model == null) {
            pSource.sendFailure((Component)Component.literal((String)("Invalid model: " + String.valueOf(modelId))));
            return 0;
        }
        try {
            ModelTier tier = (ModelTier)ModelTierRegistry.INSTANCE.getValue(HostileNetworks.loc(tierName.toLowerCase(Locale.ROOT)));
            int data = model.getRequiredData(tier);
        }
        catch (Exception ex) {
            pSource.sendFailure((Component)Component.literal((String)("Invalid model tier: " + tierName)));
            return -1;
        }
        ItemStack modelStack = new ItemStack(Hostile.Items.DATA_MODEL);
        DataModelItem.setStoredModel(modelStack, model);
        DataModelItem.setData(modelStack, data += bonusData);
        for (ServerPlayer serverplayer : pTargets) {
            ItemStack stack = modelStack.copy();
            boolean flag = serverplayer.getInventory().add(stack);
            if (flag && stack.isEmpty()) {
                stack.setCount(1);
                ItemEntity itementity1 = serverplayer.drop(stack, false);
                if (itementity1 != null) {
                    itementity1.makeFakeItem();
                }
                serverplayer.level().playSound((Player)null, serverplayer.getX(), serverplayer.getY(), serverplayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverplayer.getRandom().nextFloat() - serverplayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverplayer.containerMenu.broadcastChanges();
                continue;
            }
            ItemEntity itementity = serverplayer.drop(stack, false);
            if (itementity == null) continue;
            itementity.setNoPickUpDelay();
            itementity.setTarget(serverplayer.getUUID());
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, modelStack.getDisplayName(), ((ServerPlayer)pTargets.iterator().next()).getDisplayName()}), true);
        } else {
            pSource.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, modelStack.getDisplayName(), pTargets.size()}), true);
        }
        return pTargets.size();
    }
}

