/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;

public abstract class DocIdSet
implements Accountable {
    public static final DocIdSet EMPTY = new DocIdSet(){

        @Override
        public DocIdSetIterator iterator() {
            return DocIdSetIterator.empty();
        }

        @Override
        public Bits bits() {
            return null;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }
    };

    public static DocIdSet all(final int maxDoc) {
        return new DocIdSet(){

            @Override
            public DocIdSetIterator iterator() throws IOException {
                return DocIdSetIterator.all(maxDoc);
            }

            @Override
            public Bits bits() throws IOException {
                return new Bits.MatchAllBits(maxDoc);
            }

            @Override
            public long ramBytesUsed() {
                return 4L;
            }
        };
    }

    public abstract DocIdSetIterator iterator() throws IOException;

    public Bits bits() throws IOException {
        return null;
    }
}

