/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.AbstractModularCrafterComponent;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccessBehavior;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.helper.CrafterComponentHelper;

public final class MultipliedCrafterComponent
extends AbstractModularCrafterComponent<RecipeHolder<MachineRecipe>> {
    private final Supplier<MachineRecipeType> recipeTypeGetter;
    private final Supplier<Integer> maxMultiplierGetter;
    private final Supplier<EuCostTransformer> euCostTransformer;
    private int tryRecipeMultiplier = 0;
    private int recipeMultiplier = 0;

    public MultipliedCrafterComponent(MachineBlockEntity blockEntity, CrafterComponent.Inventory inventory, ModularCrafterAccessBehavior behavior, Supplier<MachineRecipeType> recipeTypeGetter, Supplier<Integer> maxMultiplierGetter, Supplier<EuCostTransformer> euCostTransformer) {
        super(blockEntity, inventory, behavior);
        this.recipeTypeGetter = recipeTypeGetter;
        this.maxMultiplierGetter = maxMultiplierGetter;
        this.euCostTransformer = euCostTransformer;
    }

    public MachineRecipeType getRecipeType() {
        return this.recipeTypeGetter.get();
    }

    public int getRecipeMultiplier() {
        return this.recipeMultiplier;
    }

    public int getMaxMultiplier() {
        return this.maxMultiplierGetter.get();
    }

    @Override
    public long transformEuCost(long eu) {
        return this.euCostTransformer.get().transform(this, eu);
    }

    @Override
    protected boolean canContinueRecipe() {
        return this.recipeMultiplier != 0;
    }

    @Override
    protected ResourceLocation getRecipeId(RecipeHolder<MachineRecipe> recipe) {
        return recipe.id();
    }

    @Override
    protected RecipeHolder<MachineRecipe> getRecipeById(ResourceLocation recipeId) {
        MachineRecipeType type = this.getRecipeType();
        return type != null ? type.getRecipe(this.behavior.getCrafterWorld(), recipeId) : null;
    }

    public long getBaseRecipeEu() {
        return ((MachineRecipe)((RecipeHolder)this.activeRecipe).value()).eu;
    }

    @Override
    public long getRecipeEuCost(RecipeHolder<MachineRecipe> recipe) {
        return ((MachineRecipe)recipe.value()).eu;
    }

    @Override
    public long getRecipeTotalEuCost(RecipeHolder<MachineRecipe> recipe) {
        return ((MachineRecipe)recipe.value()).getTotalEu();
    }

    @Override
    public boolean doConditionsMatchForRecipe(RecipeHolder<MachineRecipe> recipe) {
        return ((MachineRecipe)recipe.value()).conditionsMatch(this.conditionContext);
    }

    @Override
    protected void onTick() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Iterable<RecipeHolder<MachineRecipe>> getRecipes() {
        if (this.getRecipeType() == null) {
            return Collections.emptyList();
        }
        if (this.efficiencyTicks > 0) {
            return Collections.singletonList((RecipeHolder)this.activeRecipe);
        }
        int currentHash = this.inventory.hash();
        if (currentHash == this.lastInvHash) {
            if (this.lastForcedTick != 0) {
                --this.lastForcedTick;
                return Collections.emptyList();
            }
            this.lastForcedTick = 100;
        } else {
            this.lastInvHash = currentHash;
        }
        ServerLevel serverWorld = this.behavior.getCrafterWorld();
        MachineRecipeType recipeType = this.getRecipeType();
        ArrayList<RecipeHolder<MachineRecipe>> recipes = new ArrayList<RecipeHolder<MachineRecipe>>(recipeType.getFluidOnlyRecipes(serverWorld));
        Iterator iterator = this.inventory.getItemInputs().iterator();
        while (iterator.hasNext()) {
            ConfigurableItemStack stack = (ConfigurableItemStack)iterator.next();
            if (stack.isEmpty()) continue;
            recipes.addAll(recipeType.getMatchingRecipes(serverWorld, ((ItemVariant)stack.getResource()).getItem()));
        }
        return recipes;
    }

    private int calculateItemInputRecipeMultiplier(MachineRecipe recipe) {
        List<ItemStack> itemsInHatches = this.inventory.getItemInputs().stream().map(item -> ((ItemVariant)item.getResource()).toStack((int)item.getAmount())).toList();
        int itemMultiplier = this.getMaxMultiplier();
        for (MachineRecipe.ItemInput input : recipe.itemInputs) {
            int countItemsInHatches = 0;
            for (ItemStack stack : itemsInHatches) {
                if (!input.matches(stack)) continue;
                countItemsInHatches += stack.getCount();
            }
            if (input.probability() == 0.0f && countItemsInHatches >= input.amount()) continue;
            int multiplier = countItemsInHatches / input.amount();
            if (multiplier < itemMultiplier) {
                itemMultiplier = multiplier;
            }
            if (itemMultiplier > 1) continue;
            break;
        }
        return itemMultiplier;
    }

    private int calculateItemOutputRecipeMultiplier(MachineRecipe recipe) {
        int multiplier = 1;
        int maxMultiplier = this.getMaxMultiplier();
        while (multiplier < maxMultiplier) {
            int middleMultiplier = (multiplier + maxMultiplier + 1) / 2;
            if (this.canItemOutputsAllFit(recipe, middleMultiplier)) {
                multiplier = middleMultiplier;
                continue;
            }
            maxMultiplier = middleMultiplier - 1;
        }
        return multiplier;
    }

    private boolean canItemOutputsAllFit(MachineRecipe recipe, int multiplier) {
        try (Transaction transaction = Transaction.openOuter();){
            MIItemStorage outputStorage = new MIItemStorage(this.inventory.getItemOutputs());
            for (MachineRecipe.ItemOutput output : recipe.itemOutputs) {
                if (output.probability() < 1.0f) continue;
                int outputAmount = output.amount() * multiplier;
                long inserted = outputStorage.insertAllSlot((TransferVariant)output.variant(), (long)outputAmount, (TransactionContext)transaction);
                if (inserted == (long)outputAmount) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private int calculateFluidInputRecipeMultiplier(MachineRecipe recipe) {
        int fluidMultiplier = this.getMaxMultiplier();
        for (MachineRecipe.FluidInput input : recipe.fluidInputs) {
            long countFluidInHatches = 0L;
            for (ConfigurableFluidStack stack : this.inventory.getFluidInputs()) {
                if (!CrafterComponentHelper.fluidIngredientMatch((FluidVariant)stack.getResource(), input.fluid())) continue;
                countFluidInHatches += stack.getAmount();
            }
            if (input.probability() == 0.0f && countFluidInHatches >= input.amount()) continue;
            int multiplier = (int)(countFluidInHatches / input.amount());
            if (multiplier < fluidMultiplier) {
                fluidMultiplier = multiplier;
            }
            if (fluidMultiplier > 1) continue;
            break;
        }
        return fluidMultiplier;
    }

    private int calculateFluidOutputRecipeMultiplier(MachineRecipe recipe) {
        int fluidMultiplier = this.getMaxMultiplier();
        block0: for (int i = 0; i < Math.min(recipe.fluidOutputs.size(), this.behavior.getMaxFluidOutputs()); ++i) {
            MachineRecipe.FluidOutput output = (MachineRecipe.FluidOutput)recipe.fluidOutputs.get(i);
            if (output.probability() < 1.0f) continue;
            long maxOutputCount = output.amount() * (long)this.getMaxMultiplier();
            for (int tries = 0; tries < 2; ++tries) {
                for (ConfigurableFluidStack stack : this.inventory.getFluidOutputs()) {
                    FluidVariant outputKey;
                    if (!stack.isResourceAllowedByLock((TransferVariant)(outputKey = FluidVariant.of((Fluid)output.fluid()))) || (tries != 1 || !stack.isResourceBlank()) && !((FluidVariant)stack.getResource()).equals((Object)outputKey)) continue;
                    long outputSpace = Math.min(stack.getRemainingSpace(), maxOutputCount);
                    int multiplier = (int)(outputSpace / output.amount());
                    if (multiplier < fluidMultiplier) {
                        fluidMultiplier = multiplier;
                    }
                    if (fluidMultiplier > 1) continue;
                    continue block0;
                }
            }
        }
        return fluidMultiplier;
    }

    @Override
    protected boolean takeItemInputs(RecipeHolder<MachineRecipe> recipeHolder, boolean simulate) {
        return CrafterComponentHelper.takeItemInputs((MachineRecipe)recipeHolder.value(), simulate, this.behavior, this.inventory, this.tryRecipeMultiplier);
    }

    @Override
    protected boolean takeFluidInputs(RecipeHolder<MachineRecipe> recipeHolder, boolean simulate) {
        return CrafterComponentHelper.takeFluidInputs((MachineRecipe)recipeHolder.value(), simulate, this.behavior, this.inventory, this.tryRecipeMultiplier);
    }

    @Override
    protected boolean putItemOutputs(RecipeHolder<MachineRecipe> recipeHolder, boolean simulate, boolean toggleLock) {
        return CrafterComponentHelper.putItemOutputs((MachineRecipe)recipeHolder.value(), simulate, toggleLock, this.behavior, this.inventory, this.tryRecipeMultiplier == 0 ? this.recipeMultiplier : this.tryRecipeMultiplier);
    }

    @Override
    protected boolean putFluidOutputs(RecipeHolder<MachineRecipe> recipeHolder, boolean simulate, boolean toggleLock) {
        return CrafterComponentHelper.putFluidOutputs((MachineRecipe)recipeHolder.value(), simulate, toggleLock, this.behavior, this.inventory, this.tryRecipeMultiplier == 0 ? this.recipeMultiplier : this.tryRecipeMultiplier);
    }

    @Override
    protected boolean tryStartRecipe(RecipeHolder<MachineRecipe> recipe) {
        int itemOutputMultiplier;
        int itemInputMultiplier;
        if (this.getMaxMultiplier() > 1 && (itemInputMultiplier = this.calculateItemInputRecipeMultiplier((MachineRecipe)recipe.value())) > 1 && (itemOutputMultiplier = this.calculateItemOutputRecipeMultiplier((MachineRecipe)recipe.value())) > 1) {
            int fluidOutputMultiplier;
            int itemMultiplier = Math.min(itemInputMultiplier, itemOutputMultiplier);
            int fluidInputMultiplier = this.calculateFluidInputRecipeMultiplier((MachineRecipe)recipe.value());
            if (fluidInputMultiplier > 1 && (fluidOutputMultiplier = this.calculateFluidOutputRecipeMultiplier((MachineRecipe)recipe.value())) > 1) {
                int fluidMultiplier = Math.min(fluidInputMultiplier, fluidOutputMultiplier);
                this.tryRecipeMultiplier = Math.min(itemMultiplier, fluidMultiplier);
                if (super.tryStartRecipe(recipe)) {
                    this.recipeMultiplier = this.tryRecipeMultiplier;
                    this.tryRecipeMultiplier = 0;
                    return true;
                }
            }
        }
        this.tryRecipeMultiplier = 1;
        this.recipeMultiplier = 1;
        boolean success = super.tryStartRecipe(recipe);
        this.tryRecipeMultiplier = 0;
        return success;
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeNbt(tag, registries);
        tag.putInt("recipeMultiplier", this.recipeMultiplier);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        super.readNbt(tag, registries, isUpgradingMachine);
        this.recipeMultiplier = tag.getInt("recipeMultiplier");
    }

    @Override
    protected void clearActiveRecipes() {
        super.clearActiveRecipes();
        this.recipeMultiplier = 0;
    }

    @Override
    public void lockRecipe(ResourceLocation recipeId, Inventory inventory) {
        MachineRecipeType recipeType = this.getRecipeType();
        if (recipeType == null) {
            return;
        }
        recipeType.getRecipesWithCache(this.behavior.getCrafterWorld()).stream().filter(recipe -> recipe.id().equals((Object)recipeId)).findFirst().ifPresent(recipe -> CrafterComponentHelper.lockRecipe((MachineRecipe)recipe.value(), inventory, this.inventory));
    }
}

