/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.common.impl.unused;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import net.darkhax.openloader.common.impl.OpenLoader;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.repository.Pack;

public record PackOptions(boolean enabled, boolean required, Pack.Position position, Optional<Component> name, Optional<Component> description, boolean includeSourceName, boolean fixedPosition) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final PackOptions DEFAULT_OPTIONS = new PackOptions(true, true, Pack.Position.TOP, Optional.empty(), Optional.empty(), true, false);
    public static final Codec<Pack.Position> POSITION = Codec.STRING.xmap(PackOptions::positionFromName, Enum::name);
    public static final Codec<PackOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(PackOptions::enabled), (App)Codec.BOOL.optionalFieldOf("required", (Object)true).forGetter(PackOptions::required), (App)POSITION.optionalFieldOf("position", (Object)Pack.Position.TOP).forGetter(PackOptions::position), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(PackOptions::name), (App)ComponentSerialization.CODEC.optionalFieldOf("description").forGetter(PackOptions::description), (App)Codec.BOOL.optionalFieldOf("include_source_name", (Object)true).forGetter(PackOptions::includeSourceName), (App)Codec.BOOL.optionalFieldOf("fixed_position", (Object)false).forGetter(PackOptions::fixedPosition)).apply((Applicative)instance, PackOptions::new));

    public PackSelectionConfig selectionConfig() {
        return new PackSelectionConfig(this.required, this.position, this.fixedPosition);
    }

    public static PackOptions readOptions(File packCandidate) {
        File optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".packmeta");
        if (!optionsFile.exists() && !(optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".packmeta.json")).exists()) {
            optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".json");
        }
        if (optionsFile.exists()) {
            if (optionsFile.isFile()) {
                PackOptions packOptions;
                FileReader reader = new FileReader(optionsFile);
                try {
                    JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                    packOptions = (PackOptions)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        OpenLoader.LOG.error("Failed to read pack options. The file is not formatted correctly! {}", (Object)optionsFile.getAbsolutePath());
                        OpenLoader.LOG.catching((Throwable)e);
                    }
                }
                reader.close();
                return packOptions;
            } else {
                OpenLoader.LOG.error("Pack options must be a file! {}", (Object)optionsFile.getAbsolutePath());
            }
        }
        OpenLoader.LOG.debug("Using default pack options for {}", (Object)optionsFile.getAbsolutePath());
        return DEFAULT_OPTIONS;
    }

    private static Pack.Position positionFromName(String name) {
        if (name.equalsIgnoreCase("top")) {
            return Pack.Position.TOP;
        }
        if (name.equalsIgnoreCase("bottom")) {
            return Pack.Position.BOTTOM;
        }
        throw new IllegalStateException("Position must be top or bottom. Got " + name);
    }
}

