/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.network;

import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record DragAndDropPacket(long requesterId, int requestIndex, ItemStack item) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DragAndDropPacket> TYPE = new CustomPacketPayload.Type(Utils.getRL("drag_and_drop"));
    static final StreamCodec<RegistryFriendlyByteBuf, DragAndDropPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, DragAndDropPacket::requesterId, (StreamCodec)ByteBufCodecs.INT, DragAndDropPacket::requestIndex, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, DragAndDropPacket::item, DragAndDropPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(DragAndDropPacket payload, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof AbstractRequesterMenu) {
                AbstractRequesterMenu requester = (AbstractRequesterMenu)abstractContainerMenu;
                requester.applyDragAndDrop(serverPlayer, payload.requestIndex, payload.requesterId, payload.item);
            }
        }
    }
}

