/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.jei.common.AbstractRecipeTransferError;
import com.refinedmods.refinedstorage.jei.common.TransferInput;
import com.refinedmods.refinedstorage.jei.common.TransferType;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

class CraftingGridRecipeTransferError
extends AbstractRecipeTransferError {
    private static final Color MISSING_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.4f);
    private static final ClientTooltipComponent MISSING_ITEMS = ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"jei.tooltip.error.recipe.transfer.missing").withStyle(ChatFormatting.RED).getVisualOrderText());
    private static final List<ClientTooltipComponent> MISSING_TOOLTIP = List.of(MOVE_ITEMS, MISSING_ITEMS);
    private static final Component CTRL_CLICK_TO_AUTOCRAFT = Component.translatable((String)"gui.%s.transfer.ctrl_click_to_autocraft".formatted("refinedstorage_jei_integration"));
    private final List<TransferInput> transferInputs;
    private final TransferType type;

    CraftingGridRecipeTransferError(List<TransferInput> transferInputs, TransferType type) {
        this.transferInputs = transferInputs;
        this.type = type;
    }

    public IRecipeTransferError.Type getType() {
        return IRecipeTransferError.Type.COSMETIC;
    }

    public int getButtonHighlightColor() {
        return switch (this.type) {
            case TransferType.MISSING -> MISSING_COLOR.getRGB();
            case TransferType.MISSING_BUT_ALL_AUTOCRAFTABLE, TransferType.MISSING_BUT_SOME_AUTOCRAFTABLE -> AUTOCRAFTABLE_COLOR;
            default -> 0;
        };
    }

    public void showError(GuiGraphics graphics, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)recipeX, (float)recipeY, 0.0f);
        this.transferInputs.forEach(input -> CraftingGridRecipeTransferError.drawInputHighlight(graphics, input));
        poseStack.popPose();
        Platform.INSTANCE.renderTooltip(graphics, this.calculateTooltip(), mouseX, mouseY);
    }

    private List<ClientTooltipComponent> calculateTooltip() {
        return switch (this.type) {
            case TransferType.MISSING -> MISSING_TOOLTIP;
            case TransferType.MISSING_BUT_ALL_AUTOCRAFTABLE -> List.of(MOVE_ITEMS, CraftingGridRecipeTransferError.createAutocraftableHint((Component)Component.translatable((String)"gui.%s.transfer.missing_but_all_autocraftable".formatted("refinedstorage_jei_integration"))), HelpClientTooltipComponent.createAlwaysDisplayed((Component)CTRL_CLICK_TO_AUTOCRAFT));
            case TransferType.MISSING_BUT_SOME_AUTOCRAFTABLE -> List.of(MOVE_ITEMS, CraftingGridRecipeTransferError.createAutocraftableHint((Component)Component.translatable((String)"gui.%s.transfer.missing_but_some_autocraftable".formatted("refinedstorage_jei_integration"))), HelpClientTooltipComponent.createAlwaysDisplayed((Component)CTRL_CLICK_TO_AUTOCRAFT));
            default -> Collections.emptyList();
        };
    }

    private static void drawInputHighlight(GuiGraphics graphics, TransferInput input) {
        switch (input.type()) {
            case MISSING: {
                input.view().drawHighlight(graphics, MISSING_COLOR.getRGB());
                break;
            }
            case AUTOCRAFTABLE: {
                input.view().drawHighlight(graphics, AUTOCRAFTABLE_COLOR);
            }
        }
    }
}

