/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data.client;

import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.model.LecternPrintoutModel;
import dan200.computercraft.data.DataProviders;
import dan200.computercraft.data.client.ExtraModelsProvider;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.inventory.UpgradeSlot;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public final class ClientDataProviders {
    private ClientDataProviders() {
    }

    public static void add(DataProviders.GeneratorSink generator, CompletableFuture<HolderLookup.Provider> registries) {
        generator.addFromCodec("Block atlases", PackType.CLIENT_RESOURCES, "atlases", SpriteSources.FILE_CODEC, out -> {
            out.accept(ResourceLocation.withDefaultNamespace((String)"blocks"), List.of(new SingleFile(UpgradeSlot.LEFT_UPGRADE, Optional.empty()), new SingleFile(UpgradeSlot.RIGHT_UPGRADE, Optional.empty()), new SingleFile(LecternPrintoutModel.TEXTURE, Optional.empty())));
            out.accept(GuiSprites.SPRITE_SHEET, Stream.of(GuiSprites.TURNED_OFF.textures(), GuiSprites.TURNED_ON.textures(), GuiSprites.TERMINATE.textures(), GuiSprites.COMPUTER_NORMAL.textures(), GuiSprites.COMPUTER_ADVANCED.textures(), GuiSprites.COMPUTER_COMMAND.textures(), GuiSprites.COMPUTER_COLOUR.textures()).flatMap(x -> x).map(x -> new SingleFile(x, Optional.empty())).toList());
        });
        generator.add(pack -> new ExtraModelsProvider(pack, (CompletableFuture)registries){

            @Override
            public Stream<ResourceLocation> getModels(HolderLookup.Provider registries) {
                return registries.lookupOrThrow(TurtleOverlay.REGISTRY).listElements().map(x -> ((TurtleOverlay)x.value()).model());
            }
        });
    }
}

