/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.mojang.serialization.Codec;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.data.BlockModelProvider;
import dan200.computercraft.data.ItemModelProvider;
import dan200.computercraft.data.LanguageProvider;
import dan200.computercraft.data.LootTableProvider;
import dan200.computercraft.data.ModelProvider;
import dan200.computercraft.data.PocketUpgradeProvider;
import dan200.computercraft.data.RecipeProvider;
import dan200.computercraft.data.TagProvider;
import dan200.computercraft.data.TurtleOverlays;
import dan200.computercraft.data.TurtleUpgradeProvider;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class DataProviders {
    private DataProviders() {
    }

    public static void add(GeneratorSink generator) {
        CompletableFuture fullRegistryPatch = RegistryPatchGenerator.createLookup(generator.registries(), (RegistrySetBuilder)((RegistrySetBuilder)Util.make((Object)new RegistrySetBuilder(), builder -> {
            builder.add(ITurtleUpgrade.REGISTRY, TurtleUpgradeProvider::addUpgrades);
            builder.add(IPocketUpgrade.REGISTRY, PocketUpgradeProvider::addUpgrades);
            builder.add(TurtleOverlay.REGISTRY, TurtleOverlays::register);
        })));
        CompletionStage fullRegistries = fullRegistryPatch.thenApply(RegistrySetBuilder.PatchedRegistries::full);
        generator.registries(fullRegistryPatch);
        generator.add(arg_0 -> DataProviders.lambda$add$1((CompletableFuture)fullRegistries, arg_0));
        TagsProvider<Block> blockTags = generator.blockTags(TagProvider::blockTags);
        generator.itemTags(TagProvider::itemTags, blockTags);
        generator.add(arg_0 -> DataProviders.lambda$add$2((CompletableFuture)fullRegistries, arg_0));
        generator.add(out -> new ModelProvider(out, BlockModelProvider::addBlockModels, ItemModelProvider::addItemModels));
        generator.add(arg_0 -> DataProviders.lambda$add$4((CompletableFuture)fullRegistries, arg_0));
        try {
            Class.forName("dan200.computercraft.data.client.ClientDataProviders").getMethod("add", GeneratorSink.class, CompletableFuture.class).invoke(null, generator, fullRegistries);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ LanguageProvider lambda$add$4(CompletableFuture fullRegistries, PackOutput out) {
        return new LanguageProvider(out, fullRegistries);
    }

    private static /* synthetic */ net.minecraft.data.loot.LootTableProvider lambda$add$2(CompletableFuture fullRegistries, PackOutput out) {
        return new net.minecraft.data.loot.LootTableProvider(out, Set.of(), LootTableProvider.getTables(), fullRegistries);
    }

    private static /* synthetic */ RecipeProvider lambda$add$1(CompletableFuture fullRegistries, PackOutput out) {
        return new RecipeProvider(out, fullRegistries);
    }

    public static interface GeneratorSink {
        public CompletableFuture<HolderLookup.Provider> registries();

        public <T extends DataProvider> T add(DataProvider.Factory<T> var1);

        public <T> void addFromCodec(String var1, PackType var2, String var3, Codec<T> var4, Consumer<BiConsumer<ResourceLocation, T>> var5);

        public TagsProvider<Block> blockTags(Consumer<TagProvider.TagConsumer<Block>> var1);

        public TagsProvider<Item> itemTags(Consumer<TagProvider.ItemTagConsumer> var1, TagsProvider<Block> var2);

        public void registries(CompletableFuture<RegistrySetBuilder.PatchedRegistries> var1);
    }
}

