/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.schema;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.component.EnumComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.rhino.Context;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import dev.uncandango.kubejstweaks.kubejs.component.CodecComponent;
import dev.uncandango.kubejstweaks.kubejs.plugin.KJSTPluginUtils;
import dev.uncandango.kubejstweaks.kubejs.schema.CodecNode;
import dev.uncandango.kubejstweaks.kubejs.schema.CodecParsedListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.conditions.ConditionContext;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RecipeSchemaFinder {
    public static final List<Pattern> OUTPUTS;
    public static final List<Pattern> INPUTS;
    public static Map<String, RecipeComponent<?>> DEFAULT_COMPONENTS;
    private static ConditionalOps<JsonElement> conditionalOps;
    private static ArrayListMultimap<ResourceKey<RecipeSerializer<?>>, RecipeHolder<?>> serializerToRecipeMap;
    public static Map<RecipeSerializer<?>, Map<ResourceLocation, Set<Event>>> serializerEventMap;
    public static RecipeSerializer<?> currentSerializer;
    public static ResourceLocation currentRecipe;
    private final List<? extends RecipeHolder<?>> recipeHolders;
    private final Map.Entry<ResourceKey<RecipeSerializer<?>>, RecipeSerializer<?>> recipeSerializer;
    private final Map<String, RecipeComponent<?>> customComponents = new HashMap();
    private final Map<String, RecipeKeyInfo> recipeKeyInfos = new HashMap<String, RecipeKeyInfo>();

    private RecipeSchemaFinder(List<? extends RecipeHolder<?>> recipeHolders, Map.Entry<ResourceKey<RecipeSerializer<?>>, RecipeSerializer<?>> recipeSerializer) {
        this.recipeHolders = recipeHolders;
        this.recipeSerializer = recipeSerializer;
    }

    public static List<RecipeSchemaFinder> of(Set<Map.Entry<ResourceKey<RecipeSerializer<?>>, RecipeSerializer<?>>> recipeSerializers) {
        ArrayListMultimap<ResourceKey<RecipeSerializer<?>>, RecipeHolder<?>> map = RecipeSchemaFinder.getSerializersMap();
        return recipeSerializers.stream().map(entry -> new RecipeSchemaFinder(map.get((Object)((ResourceKey)entry.getKey())), (Map.Entry<ResourceKey<RecipeSerializer<?>>, RecipeSerializer<?>>)entry)).toList();
    }

    private static ArrayListMultimap<ResourceKey<RecipeSerializer<?>>, RecipeHolder<?>> getSerializersMap() {
        MinecraftServer server;
        if (serializerToRecipeMap.isEmpty() && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            Registry serializerRegistry = server.registryAccess().registryOrThrow(Registries.RECIPE_SERIALIZER);
            server.getRecipeManager().getRecipes().forEach(recipeHolder -> serializerToRecipeMap.put((Object)((ResourceKey)serializerRegistry.getResourceKey((Object)recipeHolder.kjs$getRecipe().getSerializer()).get()), recipeHolder));
        }
        return serializerToRecipeMap;
    }

    private static void clearRecipeSerializerMap() {
        serializerToRecipeMap.clear();
    }

    public static void cleanUp() {
        RecipeSchemaFinder.clearRecipeSerializerMap();
        RecipeSchemaFinder.clearConditionalOps();
    }

    private Set<Map.Entry<RecipeHolder<?>, JsonElement>> loadJsons() {
        this.refreshComponents();
        HashSet set = new HashSet();
        Context cx = KubeJS.getStartupScriptManager().contextFactory.enter();
        ArrayList toRemove = new ArrayList();
        for (RecipeHolder<?> recipeHolder : this.recipeHolders) {
            JsonElement recipeJson = KJSTPluginUtils.readJsonFromMod(cx, recipeHolder.id().getNamespace(), String.valueOf(ResourceLocation.parse((String)(recipeHolder.id().getNamespace() + ":recipe/" + recipeHolder.id().getPath()))) + ".json");
            if (recipeJson != null && !recipeJson.isJsonNull()) {
                set.add(Map.entry(recipeHolder, recipeJson));
                continue;
            }
            toRemove.add(recipeHolder);
        }
        this.recipeHolders.removeAll(toRemove);
        return set;
    }

    public void start() {
        if (this.recipeHolders.isEmpty()) {
            return;
        }
        Set<Map.Entry<RecipeHolder<?>, JsonElement>> jsons = this.loadJsons();
        CodecParsedListener.enabled.set(true);
        jsons.forEach(entry -> {
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement instanceof JsonObject) {
                JsonObject json = (JsonObject)jsonElement;
                currentSerializer = this.recipeSerializer.getValue();
                currentRecipe = ((RecipeHolder)entry.getKey()).id();
                json.remove("neoforge:conditions");
                Recipe.CONDITIONAL_CODEC.parse(RecipeSchemaFinder.getConditionalOps(), (Object)json).getOrThrow(JsonParseException::new);
                currentSerializer = null;
                currentRecipe = null;
            } else {
                KubeJSTweaks.LOGGER.warn("Invalid recipe json for {} with json {}", (Object)((RecipeHolder)entry.getKey()).id(), (Object)jsonElement);
            }
        });
        CodecParsedListener.enabled.set(false);
        serializerEventMap.forEach((serializer, recipeMap) -> {
            ArrayList<CodecNode> masterNodes = new ArrayList<CodecNode>();
            for (Map.Entry entry : recipeMap.entrySet()) {
                KubeJSTweaks.LOGGER.info("Recipe: {}", entry.getKey());
                int prevDepth = -1;
                CodecNode prevNode = null;
                HashMap<Integer, List> bufferChildsByDepth = new HashMap<Integer, List>();
                ArrayList<CodecNode> rootNodes = new ArrayList<CodecNode>();
                for (Event event : (Set)entry.getValue()) {
                    List childs;
                    CodecNode currentNode = new CodecNode(event);
                    int depth = CodecParsedListener.getDepth(event);
                    if (prevNode != null && prevDepth - depth == 1) {
                        childs = bufferChildsByDepth.computeIfAbsent(prevDepth, dp -> new ArrayList());
                        currentNode.setChilds(childs);
                        bufferChildsByDepth.put(prevDepth, new ArrayList());
                    }
                    if (depth != 0) {
                        childs = bufferChildsByDepth.computeIfAbsent(depth, dp -> new ArrayList());
                        childs.add(currentNode);
                    } else {
                        rootNodes.add(currentNode);
                    }
                    prevNode = currentNode;
                    prevDepth = depth;
                }
                if (masterNodes.isEmpty()) {
                    masterNodes = rootNodes;
                } else {
                    this.mergeNodes(rootNodes, masterNodes);
                }
                KubeJSTweaks.LOGGER.info("Root nodes: {}", (Object)rootNodes.size());
            }
            KubeJSTweaks.LOGGER.info("Master nodes: {}", (Object)masterNodes.size());
        });
        KubeJSTweaks.LOGGER.info("Size of events is: {}", (Object)serializerEventMap.size());
        HashMap<String, Object> allComponents = new HashMap<String, Object>();
        allComponents.putAll(DEFAULT_COMPONENTS);
        allComponents.putAll(this.customComponents);
        allComponents.forEach((key, component) -> this.recipeKeyInfos.values().forEach(recipeKeyInfo -> recipeKeyInfo.tryParse(Map.entry(key, component))));
        KubeJSTweaks.LOGGER.info("===========================");
        KubeJSTweaks.LOGGER.info("Recipe type {} has {} jsons", (Object)this.recipeSerializer.getKey().location(), (Object)jsons.size());
        this.recipeKeyInfos.values().forEach(RecipeKeyInfo::printSummary);
    }

    private void mergeNodes(List<CodecNode> rootNodes, List<CodecNode> masterNodes) {
        List<CodecNode> flatRootNodes = CodecNode.flattenNodes(rootNodes);
        List<CodecNode> flatMasterNodes = CodecNode.flattenNodes(masterNodes);
        if (flatMasterNodes.size() == flatRootNodes.size()) {
            boolean isEqual = true;
            for (int i = 0; i < flatRootNodes.size(); ++i) {
                if (flatMasterNodes.get(i).hasSameKeyAndDecoder(flatRootNodes.get(i))) continue;
                isEqual = false;
                break;
            }
            if (isEqual) {
                return;
            }
        }
        block1: for (CodecNode rootNode : flatRootNodes) {
            if (rootNode.parent == null) continue;
            for (CodecNode masterNode : flatMasterNodes) {
                if (masterNode.parent == null || !rootNode.isSibling(masterNode)) continue;
                boolean alreadyContains = false;
                for (CodecNode masterChild : masterNode.parent.childs) {
                    JsonElement inputMaster;
                    if (!masterChild.hasSameKeyAndDecoder(rootNode)) continue;
                    alreadyContains = true;
                    JsonElement inputRoot = CodecParsedListener.getInput(rootNode.parent.value);
                    if (inputRoot == null || !inputRoot.isJsonArray() || (inputMaster = CodecParsedListener.getInput(masterChild.parent.value)) == null) break;
                    inputMaster.getAsJsonArray().addAll(inputRoot.getAsJsonArray());
                    Object object = CodecParsedListener.getResult(masterChild.parent.value).getOrThrow();
                    if (!(object instanceof Collection)) break;
                    Collection masterList = (Collection)object;
                    object = CodecParsedListener.getResult(rootNode.parent.value).getOrThrow();
                    if (!(object instanceof Collection)) break;
                    Collection rootList = (Collection)object;
                    CodecParsedListener.setResult(masterChild.parent.value, DataResult.success(Streams.concat((Stream[])new Stream[]{masterList.stream(), rootList.stream()}).toList()));
                    break;
                }
                if (alreadyContains) continue;
                masterNode.parent.childs.add(rootNode);
                rootNode.setParent(masterNode.parent);
                continue block1;
            }
        }
    }

    private void refreshComponents() {
        DEFAULT_COMPONENTS = new HashMap();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            String[] defaultDynamicComponents;
            ServerScriptManager ssm = server.getServerResources().managers().kjs$getServerScriptManager();
            RecipeSchemaStorage storage = ssm.recipeSchemaStorage;
            storage.simpleComponents.forEach((key, value) -> {
                if (key.contains(":")) {
                    return;
                }
                DEFAULT_COMPONENTS.put((String)key, (RecipeComponent<?>)value);
            });
            DEFAULT_COMPONENTS.remove("nested_recipe");
            DEFAULT_COMPONENTS.remove("unwrapped_ingredient_list");
            DEFAULT_COMPONENTS.remove("flat_sized_ingredient");
            DEFAULT_COMPONENTS.remove("non_empty_ingredient");
            DEFAULT_COMPONENTS.remove("flat_sized_ingredient");
            DEFAULT_COMPONENTS.remove("strict_item_stack");
            for (String s : defaultDynamicComponents = new String[]{"double", "registry_element<minecraft:item>", "float", "int", "long", "pattern<ingredient>", "either<item_stack,fluid_stack>", "either<ingredient,fluid_ingredient>", "either<ingredient,codec<com.simibubi.create.foundation.fluid.FluidIngredient#CODEC>>", "either<codec<blusunrize.immersiveengineering.api.crafting.IngredientWithSize#CODEC>,item_stack>", "codec<net.minecraft.world.level.storage.loot.providers.number.NumberProviders>", "codec<net.minecraft.world.level.storage.loot.predicates.LootItemCondition#CODEC>"}) {
                try {
                    StringReader reader = new StringReader(s);
                    String key2 = reader.readUnquotedString();
                    RecipeComponentFactory factory = (RecipeComponentFactory)storage.dynamicComponents.get(key2);
                    RecipeComponent comp = factory.readComponent(ssm.getRegistries(), storage, reader);
                    DEFAULT_COMPONENTS.put(s, comp);
                }
                catch (Exception e) {
                    KubeJSTweaks.LOGGER.error("Failed to parse dynamic component {}", (Object)s, (Object)e);
                }
            }
            Class recipeClass = this.recipeHolders.getFirst().kjs$getRecipe().getClass();
            Class serializerClass = this.recipeHolders.getFirst().kjs$getRecipe().getSerializer().getClass();
            KubeJSTweaks.LOGGER.info("----------------------");
            KubeJSTweaks.LOGGER.info("Found recipe class {} and serializer class {}", (Object)recipeClass.getName(), (Object)serializerClass.getName());
            RecipeSchemaFinder.findComponentsFromClasses(recipeClass, serializerClass, this.customComponents, ssm, storage);
        }
    }

    private static void findComponentsFromClasses(Class<?> recipeClass, Class<?> serializerClass, Map<String, RecipeComponent<?>> customComponents, ServerScriptManager ssm, RecipeSchemaStorage storage) {
        HashSet<Field> recipeFields = new HashSet<Field>();
        HashSet classesToScanForCodecs = new HashSet();
        for (Class<?> currentRecipeClass = recipeClass; currentRecipeClass != Object.class; currentRecipeClass = currentRecipeClass.getSuperclass()) {
            for (Constructor<?> constructor : currentRecipeClass.getConstructors()) {
                classesToScanForCodecs.addAll(Arrays.asList(constructor.getParameterTypes()));
            }
            recipeFields.addAll(Arrays.asList(currentRecipeClass.getDeclaredFields()));
        }
        recipeFields.forEach(field -> {
            Class<?> clazz = field.getType();
            Type patt0$temp = field.getGenericType();
            if (patt0$temp instanceof ParameterizedType) {
                ParameterizedType genericType = (ParameterizedType)patt0$temp;
                for (Type type : genericType.getActualTypeArguments()) {
                    ParameterizedType genericType2;
                    Type patt1$temp;
                    if (type instanceof Class) {
                        Class clazz2 = (Class)type;
                        classesToScanForCodecs.add(clazz2);
                    }
                    if (!(type instanceof ParameterizedType) || !((patt1$temp = (genericType2 = (ParameterizedType)type).getRawType()) instanceof Class)) continue;
                    Class clazz3 = (Class)patt1$temp;
                    classesToScanForCodecs.add(clazz3);
                }
            }
            if (clazz.isEnum()) {
                try {
                    RecipeComponent component = EnumComponent.FACTORY.readComponent(ssm.getRegistries(), storage, new StringReader("<" + clazz.getName() + ">"));
                    customComponents.put("enum<" + clazz.getName() + ">", component);
                }
                catch (Exception e) {
                    KubeJSTweaks.LOGGER.error("Failed to parse enum component {}", (Object)clazz.getName(), (Object)e);
                }
            }
            classesToScanForCodecs.add(clazz.isArray() ? clazz.getComponentType() : clazz);
        });
        for (Class<?> currentSerializerClass = serializerClass; currentSerializerClass != Object.class; currentSerializerClass = currentSerializerClass.getSuperclass()) {
            for (Constructor<?> constructor : currentSerializerClass.getConstructors()) {
                classesToScanForCodecs.addAll(Arrays.asList(constructor.getParameterTypes()));
            }
            classesToScanForCodecs.add(currentSerializerClass);
        }
        List<Field> codecs = classesToScanForCodecs.stream().map(Class::getDeclaredFields).flatMap(Arrays::stream).filter(field -> field.getType() != Object.class && Modifier.isStatic(field.getModifiers()) && (field.getType().isAssignableFrom(Codec.class) || field.getType().isAssignableFrom(MapCodec.class))).toList();
        codecs.forEach(field -> {
            String module = field.getDeclaringClass().getModule().getName();
            if (module.equals("minecraft") || module.equals("neoforge")) {
                return;
            }
            try {
                customComponents.put("codec<" + field.getDeclaringClass().getName() + "#" + field.getName() + ">", CodecComponent.FACTORY.readComponent(ssm.getRegistries(), storage, new StringReader("<" + field.getDeclaringClass().getName() + "#" + field.getName() + ">")));
                KubeJSTweaks.LOGGER.info("Adding Codec {} for type {} found at class {}", new Object[]{field.getName(), field.getGenericType().getTypeName(), field.getDeclaringClass().getName()});
            }
            catch (Exception e) {
                KubeJSTweaks.LOGGER.error("Failed to parse codec component {}", (Object)field.getGenericType().getTypeName(), (Object)e);
            }
        });
    }

    private static void clearConditionalOps() {
        conditionalOps = null;
    }

    public static ConditionalOps<JsonElement> getConditionalOps() {
        if (conditionalOps != null) {
            return conditionalOps;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            ConditionContext conditionContext = new ConditionContext(server.getServerResources().managers().kjs$getTagManager());
            conditionalOps = new ConditionalOps(server.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (ICondition.IContext)conditionContext);
        }
        return conditionalOps;
    }

    static {
        serializerToRecipeMap = ArrayListMultimap.create();
        serializerEventMap = new HashMap();
        OUTPUTS = new ArrayList<Pattern>();
        OUTPUTS.add(Pattern.compile(".*result.*"));
        OUTPUTS.add(Pattern.compile(".*output.*"));
        INPUTS = new ArrayList<Pattern>();
        INPUTS.add(Pattern.compile(".*input.*"));
        INPUTS.add(Pattern.compile(".*ingredient.*"));
    }

    public static class RecipeKeyInfo {
        private final String name;
        private final List<JsonElement> jsons = new ArrayList<JsonElement>();
        private final Map<String, RecipeComponent<?>> compatibleComponents = new HashMap();
        private final List<Map.Entry<String, Object>> parsedValues = new ArrayList<Map.Entry<String, Object>>();

        public RecipeKeyInfo(String name) {
            this.name = name;
        }

        public void addJson(JsonElement json) {
            this.jsons.add(json);
        }

        public void printSummary() {
            KubeJSTweaks.LOGGER.info("===========================");
            KubeJSTweaks.LOGGER.info("Recipe key \"{}\" has {} jsons", (Object)this.name, (Object)this.jsons.size());
            HashMap occurrences = new HashMap();
            this.parsedValues.forEach(entry -> occurrences.merge((String)entry.getKey(), 1, Integer::sum));
            List partial = occurrences.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("(Partial)")).sorted(Map.Entry.comparingByValue().reversed()).toList();
            List<Map.Entry> sortedFull = occurrences.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).filter(entry -> !((String)entry.getKey()).contains("(Partial)") && (!((String)entry.getKey()).startsWith("either<") || (Integer)entry.getValue() >= this.jsons.size())).toList();
            boolean parsedFully = sortedFull.stream().anyMatch(entry -> ((Integer)entry.getValue()).intValue() == this.jsons.size());
            if (!parsedFully) {
                KubeJSTweaks.LOGGER.warn("Recipe key \"{}\" was NOT fully parsed", (Object)this.name);
            }
            if (!sortedFull.isEmpty()) {
                KubeJSTweaks.LOGGER.info("---- Fully parsed components ----");
            }
            sortedFull.stream().filter(elem -> !parsedFully || ((Integer)elem.getValue()).intValue() == this.jsons.size()).forEach(entry -> KubeJSTweaks.LOGGER.info("Component \"{}\" was parsed {} times.", entry.getKey(), entry.getValue()));
            if (!partial.isEmpty()) {
                KubeJSTweaks.LOGGER.info("---- Partially parsed components ----");
            }
            partial.forEach(entry -> KubeJSTweaks.LOGGER.info("Component \"{}\" was parsed {} times.", entry.getKey(), entry.getValue()));
        }

        public <T> void tryParse(Map.Entry<String, RecipeComponent<T>> entry) {
            this.jsons.forEach(json -> {
                DataResult.Error lifecycle;
                Object value;
                block26: {
                    try {
                        DataResult dr23333332;
                        DataResult dataResult = dr23333332 = ((RecipeComponent)entry.getValue()).codec().parse(RecipeSchemaFinder.getConditionalOps(), json);
                        Objects.requireNonNull(dataResult);
                        DataResult selector1$temp = dataResult;
                        int index$2 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)selector1$temp, index$2)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                DataResult.Error patt4$temp;
                                Object patt3$temp;
                                DataResult.Success $b$0 = (DataResult.Success)selector1$temp;
                                value = patt3$temp = $b$0.value();
                                lifecycle = patt4$temp = $b$0.lifecycle();
                                if (!((RecipeComponent)entry.getValue()).isEmpty(value)) {
                                    this.compatibleComponents.put((String)entry.getKey(), (RecipeComponent)entry.getValue());
                                    this.parsedValues.add(Map.entry((String)entry.getKey(), value));
                                    break;
                                }
                                break block26;
                            }
                            case 1: {
                                DataResult.Error patt4$temp = (DataResult.Error)selector1$temp;
                                break;
                            }
                        }
                        break block26;
                        catch (Throwable dr23333332) {
                            throw new MatchException(dr23333332.toString(), dr23333332);
                        }
                    }
                    catch (KubeRuntimeException dr23333332) {
                        // empty catch block
                    }
                }
                try {
                    DataResult drList;
                    if (!json.isJsonArray()) return;
                    DataResult dataResult = drList = ((RecipeComponent)entry.getValue()).asList().codec().parse(RecipeSchemaFinder.getConditionalOps(), json);
                    Objects.requireNonNull(dataResult);
                    DataResult selector3$temp = dataResult;
                    int index$4 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)selector3$temp, index$4)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            DataResult.Success $b$1 = (DataResult.Success)selector3$temp;
                            List patt5$temp = (List)$b$1.value();
                            value = patt5$temp;
                            Lifecycle patt6$temp = $b$1.lifecycle();
                            lifecycle = patt6$temp;
                            if (!json.getAsJsonArray().isEmpty() && ((RecipeComponent)entry.getValue()).asList().isEmpty(value)) return;
                            this.compatibleComponents.put((String)entry.getKey() + "[]", ((RecipeComponent)entry.getValue()).asList());
                            this.parsedValues.add(Map.entry((String)entry.getKey() + "[]", value));
                            return;
                        }
                        case 1: {
                            List innerList;
                            Lifecycle patt9$temp;
                            Optional patt8$temp;
                            DataResult.Error $b$2 = (DataResult.Error)selector3$temp;
                            try {
                                Supplier patt7$temp;
                                Supplier messageSupplier = patt7$temp = $b$2.messageSupplier();
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                            Optional partialValue = patt8$temp = $b$2.partialValue();
                            Lifecycle lifecycle2 = patt9$temp = $b$2.lifecycle();
                            if (!partialValue.isPresent()) return;
                            List list = (List)partialValue.get();
                            if (list.isEmpty()) {
                                return;
                            }
                            Object patt10$temp = list.getFirst();
                            if (patt10$temp instanceof List && (innerList = (List)patt10$temp).isEmpty()) {
                                return;
                            }
                            if (((String)entry.getKey()).equals("pattern<ingredient>")) {
                                return;
                            }
                            if (((String)entry.getKey()).contains("either<")) {
                                return;
                            }
                            this.compatibleComponents.put((String)entry.getKey() + "[](Partial)", ((RecipeComponent)entry.getValue()).asList());
                            this.parsedValues.add(Map.entry((String)entry.getKey() + "[](Partial)", list));
                            return;
                        }
                    }
                }
                catch (KubeRuntimeException kubeRuntimeException) {
                    // empty catch block
                }
            });
        }
    }
}

