/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.plugin;

import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.rhino.CachedClassStorage;
import dev.uncandango.kubejstweaks.kubejs.event.NoOpEventJS;
import dev.uncandango.kubejstweaks.kubejs.plugin.KJSTPluginUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.typescript.ScriptDump;
import moe.wolfgirl.probejs.lang.typescript.TypeScriptFile;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.ParamDecl;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import moe.wolfgirl.probejs.plugin.ProbeJSPlugin;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class KJSTProbeJSPlugin
extends ProbeJSPlugin {
    public void modifyClasses(ScriptDump scriptDump, Map<ClassPath, TypeScriptFile> globalClasses) {
        KJSTProbeJSPlugin.applyEdits(globalClasses, NoOpEventJS.class, decl -> {
            KJSTProbeJSPlugin.replaceType(decl, "recipes", 0, (BaseType)Types.primitive((String)"Special.RecipeId"));
            KJSTProbeJSPlugin.replaceType(decl, "lootTables", 0, (BaseType)Types.primitive((String)"Special.LootTable"));
            KJSTProbeJSPlugin.replaceType(decl, "lootTablesBlock", 0, (BaseType)Types.primitive((String)"Special.Block"));
            KJSTProbeJSPlugin.replaceType(decl, "biomeModifiers", 0, (BaseType)Types.primitive((String)"Special.NeoforgeBiomeModifier"));
        });
        KJSTProbeJSPlugin.applyEdits(globalClasses, KJSTPluginUtils.class, decl -> KJSTProbeJSPlugin.replaceType(decl, "readFromMod", 0, (BaseType)Types.primitive((String)"Special.Mod")));
    }

    private static void replaceType(ClassDecl decl, String name, int index, BaseType type) {
        for (MethodDecl method : decl.methods) {
            if (!method.name.equals(name)) continue;
            ((ParamDecl)method.params.get((int)index)).type = type;
        }
    }

    private static void applyEdits(Map<ClassPath, TypeScriptFile> globalClasses, Class<?> clazz, Consumer<ClassDecl> edits) {
        TypeScriptFile typeScriptFile = globalClasses.get(new ClassPath(clazz));
        if (typeScriptFile == null) {
            return;
        }
        typeScriptFile.findCode(ClassDecl.class).ifPresent(edits);
    }

    public Set<Class<?>> provideJavaClass(ScriptDump scriptDump) {
        if (scriptDump.scriptType != ScriptType.SERVER) {
            return Set.of();
        }
        HashSet classes = new HashSet();
        ServerScriptManager manager = (ServerScriptManager)scriptDump.manager;
        for (RecipeNamespace namespace : manager.recipeSchemaStorage.namespaces.values()) {
            for (RecipeSchemaType schemaType : namespace.values()) {
                for (RecipeKey key : schemaType.schema.keys) {
                    classes.addAll(key.component.typeInfo().getContainedComponentClasses());
                }
                classes.addAll(schemaType.schema.recipeFactory.recipeType().getContainedComponentClasses());
            }
        }
        Map map = (Map)ObfuscationReflectionHelper.getPrivateValue(CachedClassStorage.class, (Object)CachedClassStorage.GLOBAL_PUBLIC, (String)"map");
        if (map != null) {
            classes.addAll(map.keySet());
        }
        return classes;
    }
}

