/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.plugin;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class KJSTPluginUtils {
    public static WeakReference<MultiPackResourceManager> SERVER_PACK_RESOURCES = new WeakReference<Object>(null);
    public static MultiPackResourceManager CLIENT_PACK_RESOURCES;
    public static MultiPackResourceManager TEMPORARY_SERVER_PACK_RESOURCES;

    @Nullable
    public static JsonElement readJsonFromMod(Context cx, String modId, String id) {
        KJSTPackType type = ((KubeJSContext)cx).getType().equals((Object)ScriptType.CLIENT) ? KJSTPackType.ASSETS : KJSTPackType.DATA;
        return KJSTPluginUtils.readJsonFromMod(cx, modId, id, type);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static JsonElement readJsonFromMod(Context cx, String modId, String id, KJSTPackType type) {
        ResourceLocation rl;
        block11: {
            rl = KJSTPluginUtils.toJsonRL(cx, id, (String)modId);
            Object object = modId = ((String)modId).equals("minecraft") ? "vanilla" : "mod/" + (String)modId;
            if (type == KJSTPackType.ASSETS) {
                if (FMLEnvironment.dist == Dist.CLIENT) {
                    if (Minecraft.getInstance().getResourceManager().getNamespaces().isEmpty()) {
                        MultiPackResourceManager rm = CLIENT_PACK_RESOURCES;
                        if (rm != null) {
                            List resources = rm.getResourceStack(rl);
                            ScriptType kjsSide = ((KubeJSContext)cx).getType();
                            if (!kjsSide.equals((Object)ScriptType.CLIENT)) {
                                ConsoleJS.getCurrent((Context)cx).warn((Object)("You are querying the assets of " + (String)modId + " from " + String.valueOf(kjsSide) + ", remember that this is not supported on a DEDICATED SERVER."));
                            }
                            return KJSTPluginUtils.readJsonFromResourceList(cx, (String)modId, resources, rl);
                        }
                        break block11;
                    } else {
                        if (CLIENT_PACK_RESOURCES != null) {
                            CLIENT_PACK_RESOURCES = null;
                        }
                        List resources = Minecraft.getInstance().getResourceManager().getResourceStack(rl);
                        ScriptType kjsSide = ((KubeJSContext)cx).getType();
                        if (!kjsSide.equals((Object)ScriptType.CLIENT)) {
                            ConsoleJS.getCurrent((Context)cx).warn((Object)("You are querying the assets of " + (String)modId + " from " + String.valueOf(kjsSide) + ", remember that this is not supported on a DEDICATED SERVER."));
                        }
                        return KJSTPluginUtils.readJsonFromResourceList(cx, (String)modId, resources, rl);
                    }
                }
                ConsoleJS.getCurrent((Context)cx).error((Object)("Failed to get json with id " + String.valueOf(rl) + ", not possible to get assets from dedicated server."));
            }
        }
        if (type == KJSTPackType.DATA) {
            MultiPackResourceManager rm;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                List resources = server.getResourceManager().getResourceStack(rl);
                return KJSTPluginUtils.readJsonFromResourceList(cx, (String)modId, resources, rl);
            }
            MultiPackResourceManager multiPackResourceManager = rm = SERVER_PACK_RESOURCES.get() == null ? KJSTPluginUtils.loadTemporaryServerPackResources() : (MultiPackResourceManager)SERVER_PACK_RESOURCES.get();
            if (rm != null) {
                List resources = rm.getResourceStack(rl);
                return KJSTPluginUtils.readJsonFromResourceList(cx, (String)modId, resources, rl);
            }
            ConsoleJS.getCurrent((Context)cx).error((Object)("Failed to get json with id " + String.valueOf(rl) + ", not ready yet."));
        }
        return JsonNull.INSTANCE;
    }

    private static MultiPackResourceManager loadTemporaryServerPackResources() {
        if (TEMPORARY_SERVER_PACK_RESOURCES != null) {
            return TEMPORARY_SERVER_PACK_RESOURCES;
        }
        HashMap map = Maps.newHashMap();
        RepositorySource source = ResourcePackLoader.buildPackFinder((Map)map, (PackType)PackType.SERVER_DATA);
        PackRepository packRepo = new PackRepository(new RepositorySource[]{source});
        ResourcePackLoader.populatePackRepository((PackRepository)packRepo, (PackType)PackType.SERVER_DATA, (boolean)false);
        packRepo.reload();
        ServerPacksSource vanillaPack = new ServerPacksSource(new DirectoryValidator(path -> true));
        ArrayList<VanillaPackResources> packs = new ArrayList<VanillaPackResources>(packRepo.openAllSelected());
        packs.addFirst(vanillaPack.getVanillaPack());
        TEMPORARY_SERVER_PACK_RESOURCES = new MultiPackResourceManager(PackType.SERVER_DATA, packs);
        return TEMPORARY_SERVER_PACK_RESOURCES;
    }

    private static JsonElement readJsonFromResourceList(Context cx, String modId, List<Resource> resources, ResourceLocation id) {
        ArrayList<String> modsFound = new ArrayList<String>();
        Resource found = null;
        for (Resource resource : resources) {
            modsFound.add(resource.sourcePackId());
            if (found != null) continue;
            found = resource.sourcePackId().equals(modId) ? resource : null;
        }
        if (found != null) {
            JsonElement jsonElement;
            block11: {
                InputStream reader = found.open();
                try {
                    if (modsFound.size() > 1) {
                        ConsoleJS.getCurrent((Context)cx).warn((Object)("Multiple mods (" + String.valueOf(modsFound) + ") found for resource " + String.valueOf(id) + ", using " + found.sourcePackId()));
                    }
                    jsonElement = JsonIO.parseRaw((String)new String(reader.readAllBytes()));
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ConsoleJS.getCurrent((Context)cx).error("Not possible to read json", (Throwable)e);
                    }
                }
                reader.close();
            }
            return jsonElement;
        }
        ConsoleJS.getCurrent((Context)cx).error((Object)("Not possible to read json with id " + String.valueOf(id) + ", resource not found."));
        return JsonNull.INSTANCE;
    }

    private static ResourceLocation toJsonRL(Context cx, String id, String modId) {
        String extension = ((String)id).substring(((String)id).lastIndexOf(46) + 1);
        if (extension.equals("json")) {
            return ((String)id).indexOf(58) >= 0 ? ResourceLocation.parse((String)id) : ResourceLocation.fromNamespaceAndPath((String)modId, (String)id);
        }
        if (extension.equals(id)) {
            return ((String)(id = (String)id + ".json")).indexOf(58) >= 0 ? ResourceLocation.parse((String)id) : ResourceLocation.fromNamespaceAndPath((String)modId, (String)id);
        }
        throw new IllegalStateException("Failed to read json with id " + (String)id + ", extension " + extension + " is invalid, only json is supported");
    }

    public static Class<?> getClass(Object obj) {
        if (obj instanceof Class) {
            Class clazz = (Class)obj;
            return clazz;
        }
        return obj.getClass();
    }

    public static Class<?> getSuperclass(Object object) {
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return clazz.getSuperclass();
        }
        if (object instanceof NativeJavaObject) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)object;
            return nativeJavaObject.unwrap().getClass().getSuperclass();
        }
        throw new IllegalStateException("Failed to get superclass of " + String.valueOf(object));
    }

    static {
        TEMPORARY_SERVER_PACK_RESOURCES = null;
    }

    public static enum KJSTPackType {
        ASSETS(PackType.CLIENT_RESOURCES),
        DATA(PackType.SERVER_DATA);

        private final PackType packType;

        private KJSTPackType(PackType packType) {
            this.packType = packType;
        }
    }
}

