/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.codecs.EitherCodec;
import com.mojang.serialization.codecs.FieldDecoder;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.OptionalFieldCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.util.Cast;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import dev.uncandango.kubejstweaks.kubejs.codec.CodecScanner;
import dev.uncandango.kubejstweaks.kubejs.schema.RecipeSchemaFinder;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.server.command.ModIdArgument;
import org.jetbrains.annotations.Nullable;

public class KJSTCommands {
    private static final Set<Class<?>> visitedDecoders = new HashSet();
    private static final Set<Class<?>> visitedSupportedDecoders = new HashSet();
    private static final Set<Class<?>> visitedSupportedUnsupportedDecoders = new HashSet();
    private static final List<Class<?>> skipClasses = List.of(Encoder.class, MapEncoder.class, Supplier.class);

    public static void registerClientCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        if (!FMLEnvironment.production) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kjstweaks").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"generate_schemas").executes(cmd -> KJSTCommands.generateRecipeSchemas((CommandSourceStack)cmd.getSource(), "all mods", SchemaFilter.FULL))).then(Commands.literal((String)"by_mod").then(Commands.argument((String)"mod_ids", (ArgumentType)ModIdArgument.modIdArgument()).executes(cmd -> KJSTCommands.generateRecipeSchemas((CommandSourceStack)cmd.getSource(), (String)cmd.getArgument("mod_ids", String.class), SchemaFilter.BY_MOD))))).then(Commands.literal((String)"by_recipe").then(Commands.argument((String)"recipe_serializers_ids", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.RECIPE_SERIALIZER)).executes(cmd -> KJSTCommands.generateRecipeSchemas((CommandSourceStack)cmd.getSource(), ((ResourceKey)cmd.getArgument("recipe_serializers_ids", ResourceKey.class)).location().toString(), SchemaFilter.BY_RECIPE)))))).then(Commands.literal((String)"scan_codec").executes(cmd -> KJSTCommands.scanCodec((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"test_codec_context").executes(cmd -> KJSTCommands.deconstructCodec((CommandSourceStack)cmd.getSource()))));
        }
    }

    private static int deconstructCodec(CommandSourceStack source) {
        visitedDecoders.clear();
        visitedSupportedDecoders.clear();
        visitedSupportedUnsupportedDecoders.clear();
        HolderLookup.RegistryLookup recipeLookup = (HolderLookup.RegistryLookup)source.registryAccess().lookup(Registries.RECIPE_SERIALIZER).orElseThrow();
        recipeLookup.listElements().forEach(recipeSerializerReference -> {
            KubeJSTweaks.LOGGER.info("Found recipe serializer: {}", (Object)recipeSerializerReference.getKey().location());
            MapCodec codec = ((RecipeSerializer)recipeSerializerReference.value()).codec();
            KJSTCommands.getMapCodecContext(codec, null);
        });
        return 1;
    }

    private static CodecContext getCodecContext(Decoder<?> decoder, @Nullable CodecContext context) {
        block11: {
            if (context == null) {
                context = new CodecContext(decoder);
            }
            if (CodecScanner.codecFields.containsKey(decoder)) {
                Field field = CodecScanner.codecFields.get(decoder);
                try {
                    field.setAccessible(true);
                    field.get(null);
                    KubeJSTweaks.LOGGER.info("Found codec: {}, at class: {}, with field: {}", new Object[]{field.getGenericType(), field.getDeclaringClass(), field.getName()});
                    Module module = field.getDeclaringClass().getModule();
                    if (module == null || !module.getName().equals("minecraft") && !module.getName().equals("neoforge")) break block11;
                    KubeJSTweaks.LOGGER.info("Found primitive codec from {} and class {}", (Object)field.getDeclaringClass().getModule(), (Object)field.getGenericType());
                    if (field.getGenericType().getTypeName().equals("com.mojang.serialization.Codec<net.minecraft.resources.ResourceLocation>")) {
                        try {
                            Object decoder2 = ObfuscationReflectionHelper.getPrivateValue((Class)((Class)Cast.to((Object)decoder.getClass())), decoder, (String)"val$decoder");
                            Object function = ObfuscationReflectionHelper.getPrivateValue((Class)((Class)Cast.to(decoder2.getClass())), (Object)decoder2, (String)"val$function");
                            Object arg1 = ObfuscationReflectionHelper.getPrivateValue((Class)((Class)Cast.to(function.getClass())), (Object)function, (String)"arg$1");
                            KubeJSTweaks.LOGGER.info("Found registry key at {}", arg1);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return context;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (decoder instanceof EitherCodec) {
            EitherCodec either = (EitherCodec)decoder;
            KubeJSTweaks.LOGGER.info("Reached an either first");
            KJSTCommands.getCodecContext(either.first(), context);
            KubeJSTweaks.LOGGER.info("Reached an either second");
            KJSTCommands.getCodecContext(either.second(), context);
            return context;
        }
        if (decoder instanceof MapCodec.MapCodecCodec) {
            MapCodec.MapCodecCodec mapCodecCodec = (MapCodec.MapCodecCodec)decoder;
            KubeJSTweaks.LOGGER.info("Reached a map");
            KJSTCommands.getMapCodecContext(mapCodecCodec.codec(), context);
            return context;
        }
        if (decoder instanceof ListCodec) {
            ListCodec listCodecCodec = (ListCodec)decoder;
            KubeJSTweaks.LOGGER.info("Reached a list");
            KJSTCommands.getCodecContext(listCodecCodec.elementCodec(), context);
            return context;
        }
        Decoder<?> newDecoder = KJSTCommands.unwrapDecoder(decoder);
        if (newDecoder != decoder) {
            KJSTCommands.getCodecContext(newDecoder, context);
        }
        return context;
    }

    private static CodecContext getMapCodecContext(MapDecoder<?> mapDecoder, @Nullable CodecContext context) {
        block11: {
            if (context == null) {
                context = new CodecContext(mapDecoder);
            }
            if (CodecScanner.codecFields.containsKey(mapDecoder)) {
                Field field = CodecScanner.codecFields.get(mapDecoder);
                try {
                    field.setAccessible(true);
                    field.get(null);
                    KubeJSTweaks.LOGGER.info("Found codec: {}, at class: {}, with field: {}", new Object[]{field.getGenericType(), field.getDeclaringClass(), field.getName()});
                    Module module = field.getDeclaringClass().getModule();
                    if (module == null || !module.getName().equals("minecraft") && !module.getName().equals("neoforge")) break block11;
                    KubeJSTweaks.LOGGER.info("Found primitive codec from {} and class {}", (Object)field.getDeclaringClass().getModule(), (Object)field.getGenericType());
                    try {
                        Object decoder = ObfuscationReflectionHelper.getPrivateValue((Class)((Class)Cast.to((Object)mapDecoder.getClass())), mapDecoder, (String)"val$decoder");
                        Object function = ObfuscationReflectionHelper.getPrivateValue((Class)((Class)Cast.to(decoder.getClass())), (Object)decoder, (String)"val$function");
                        Object arg1 = ObfuscationReflectionHelper.getPrivateValue((Class)((Class)Cast.to(function.getClass())), (Object)function, (String)"arg$1");
                        KubeJSTweaks.LOGGER.info("Found registry key at {}", arg1);
                    }
                    catch (Throwable decoder) {
                        // empty catch block
                    }
                    return context;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (mapDecoder instanceof KeyDispatchCodec) {
            KeyDispatchCodec keyDispatchCodec = (KeyDispatchCodec)mapDecoder;
            KubeJSTweaks.LOGGER.info("Reached a key dispatch codec {}", (Object)keyDispatchCodec);
            return context;
        }
        if (mapDecoder instanceof OptionalFieldCodec) {
            OptionalFieldCodec ofc = (OptionalFieldCodec)mapDecoder;
            KubeJSTweaks.LOGGER.info("Reached an optional field codec {}", (Object)ofc);
            KJSTCommands.getCodecContext((Decoder)ObfuscationReflectionHelper.getPrivateValue(OptionalFieldCodec.class, (Object)ofc, (String)"elementCodec"), context);
            return context;
        }
        if (mapDecoder instanceof FieldDecoder) {
            FieldDecoder fieldDecoder = (FieldDecoder)mapDecoder;
            KubeJSTweaks.LOGGER.info("Reached a field decoder {}", (Object)fieldDecoder);
            KJSTCommands.getCodecContext((Decoder)ObfuscationReflectionHelper.getPrivateValue(FieldDecoder.class, (Object)fieldDecoder, (String)"elementCodec"), context);
            return context;
        }
        List<Object> newDecoders = KJSTCommands.unwrapMapDecoder(mapDecoder);
        for (Object decoder : newDecoders) {
            if (decoder instanceof MapDecoder) {
                MapDecoder mapDecoder2 = (MapDecoder)decoder;
                KJSTCommands.getMapCodecContext(mapDecoder2, context);
            }
            if (!(decoder instanceof Decoder)) continue;
            Decoder decoder2 = (Decoder)decoder;
            KJSTCommands.getCodecContext(decoder2, context);
        }
        return context;
    }

    private static Decoder<?> unwrapDecoder(Decoder<?> decoder) {
        Decoder<?> newDecoder = decoder;
        for (Field field : decoder.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object value = field.get(decoder);
                if (value instanceof Decoder) {
                    Decoder decoder2 = (Decoder)value;
                    return decoder2;
                }
                if (value instanceof MapDecoder) {
                    MapDecoder mapDecoder = (MapDecoder)value;
                    return mapDecoder.decoder();
                }
                if (!(value instanceof com.google.common.base.Supplier)) continue;
                com.google.common.base.Supplier supplier = (com.google.common.base.Supplier)value;
                return (Decoder)supplier.get();
            }
            catch (Exception e) {
                KubeJSTweaks.LOGGER.error("Error unwrapping codec", (Throwable)e);
            }
        }
        return newDecoder;
    }

    private static List<Object> unwrapMapDecoder(MapDecoder<?> decoder) {
        Field[] fields;
        ArrayList<Object> newDecoders = new ArrayList<Object>();
        for (Field field : fields = (Field[])Stream.concat(Arrays.stream(decoder.getClass().getSuperclass().getDeclaredFields()), Arrays.stream(decoder.getClass().getDeclaredFields())).toArray(size -> (Field[])Array.newInstance(Field.class, size))) {
            try {
                field.setAccessible(true);
                Object value = field.get(decoder);
                if (value instanceof Decoder) {
                    Decoder decoder2 = (Decoder)value;
                    newDecoders.add(decoder2);
                }
                if (value instanceof MapDecoder) {
                    MapDecoder mapDecoder2 = (MapDecoder)value;
                    newDecoders.add(mapDecoder2);
                }
                if (value instanceof RecordCodecBuilder) {
                    RecordCodecBuilder recordCodecBuilder = (RecordCodecBuilder)value;
                    newDecoders.add(ObfuscationReflectionHelper.getPrivateValue(RecordCodecBuilder.class, (Object)recordCodecBuilder, (String)"decoder"));
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                for (Object element : list) {
                    for (Field elementField : element.getClass().getDeclaredFields()) {
                        elementField.setAccessible(true);
                        Object elementValue = elementField.get(element);
                        if (elementValue instanceof Decoder) {
                            Decoder elementDecoder = (Decoder)elementValue;
                            newDecoders.add(elementDecoder);
                        }
                        if (!(elementValue instanceof MapDecoder)) continue;
                        MapDecoder mapDecoder2 = (MapDecoder)elementValue;
                        newDecoders.add(mapDecoder2);
                    }
                }
            }
            catch (Throwable e) {
                KubeJSTweaks.LOGGER.error("Error unwrapping codec", e);
            }
        }
        return newDecoders;
    }

    private static int generateRecipeSchemas(CommandSourceStack source, String search, SchemaFilter filter) {
        if (FMLEnvironment.production) {
            source.sendFailure((Component)Component.literal((String)"This is a WIP feature"));
            return 0;
        }
        Registry recipeTypeRegistry = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.RECIPE_SERIALIZER);
        HashSet targetRecipeTypes = new HashSet();
        if (filter == SchemaFilter.BY_MOD) {
            Set recipeTypes = recipeTypeRegistry.entrySet();
            recipeTypes.stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().equals(search)).forEach(targetRecipeTypes::add);
        }
        if (filter == SchemaFilter.BY_RECIPE) {
            ResourceLocation id = ResourceLocation.parse((String)search);
            recipeTypeRegistry.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().equals((Object)id)).forEach(targetRecipeTypes::add);
        }
        if (filter == SchemaFilter.FULL) {
            targetRecipeTypes.addAll(recipeTypeRegistry.entrySet());
        }
        List<RecipeSchemaFinder> finders = RecipeSchemaFinder.of(targetRecipeTypes);
        RecipeSchemaFinder.serializerEventMap.clear();
        finders.forEach(RecipeSchemaFinder::start);
        KubeJSTweaks.LOGGER.info("Found {} recipe serializers for {}", (Object)targetRecipeTypes.size(), (Object)search);
        return 1;
    }

    private static int scanCodec(CommandSourceStack source) {
        CodecScanner.scanVanilla();
        return 1;
    }

    private static class CodecContext {
        private final Object decoder;

        public CodecContext(Object decoder) {
            this.decoder = decoder;
        }
    }

    public static enum SchemaFilter {
        BY_MOD,
        BY_RECIPE,
        FULL;

    }
}

