/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks;

import com.mojang.brigadier.CommandDispatcher;
import dev.uncandango.kubejstweaks.Config;
import dev.uncandango.kubejstweaks.command.KJSTCommands;
import dev.uncandango.kubejstweaks.kubejs.schema.CodecParsedListener;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;

@Mod(value="kubejstweaks")
public class KubeJSTweaks {
    public static final String MODID = "kubejstweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"KubeJS Tweaks");
    private static IEventBus MOD_EVENT_BUS;
    private static final Path LOCAL;

    public KubeJSTweaks(IEventBus modEventBus, ModContainer modContainer) {
        MOD_EVENT_BUS = modEventBus;
        modEventBus.addListener(this::loadCompleteSetup);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.addListener(this::registerClientCommands);
        }
    }

    public static Path getLocal() {
        return LOCAL;
    }

    private void loadCompleteSetup(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            try {
                Class<?> clazz = Class.forName("com.mojang.serialization.Decoder$CodecParsedEvent");
                MOD_EVENT_BUS.addListener(clazz, CodecParsedListener::codecParsed);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to listen to event of codec parsed", (Throwable)e);
            }
        });
        if (!FMLEnvironment.production) {
            event.enqueueWork(() -> MixinEnvironment.getCurrentEnvironment().audit());
        }
    }

    public void registerClientCommands(RegisterClientCommandsEvent event) {
        KJSTCommands.registerClientCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    static {
        LOCAL = FMLPaths.GAMEDIR.get().resolve("local").resolve(MODID);
    }
}

