/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.query.lexer;

import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlightedCharacter;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighterColors;
import com.refinedmods.refinedstorage.query.lexer.Token;
import java.util.ArrayList;
import java.util.List;

public class SyntaxHighlighter {
    private final SyntaxHighlighterColors colors;

    public SyntaxHighlighter(SyntaxHighlighterColors colors) {
        this.colors = colors;
    }

    public List<SyntaxHighlightedCharacter> highlight(String text, List<Token> tokens) {
        List<SyntaxHighlightedCharacter> characters = this.createInitialCharacters(text);
        for (Token token : tokens) {
            int begin = token.position().range().startColumn() - 1;
            int end = token.position().range().endColumn();
            for (int i = begin; i < end; ++i) {
                characters.get(i).setColor(this.colors.getColor(token.type()));
            }
        }
        return characters;
    }

    private List<SyntaxHighlightedCharacter> createInitialCharacters(String text) {
        ArrayList<SyntaxHighlightedCharacter> items = new ArrayList<SyntaxHighlightedCharacter>();
        for (char c : text.toCharArray()) {
            items.add(new SyntaxHighlightedCharacter(String.valueOf(c), this.colors.getDefaultColor()));
        }
        return items;
    }
}

