/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.support.inventory;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class InsertExtractItemHandler
implements IItemHandler {
    private final IItemHandler insertHandler;
    private final IItemHandler extractHandler;

    public InsertExtractItemHandler(IItemHandler insertHandler, IItemHandler extractHandler) {
        this.insertHandler = insertHandler;
        this.extractHandler = extractHandler;
    }

    public int getSlots() {
        return this.insertHandler.getSlots() + this.extractHandler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return slot < this.insertHandler.getSlots() ? this.insertHandler.getStackInSlot(slot) : this.extractHandler.getStackInSlot(slot - this.insertHandler.getSlots());
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return slot < this.insertHandler.getSlots() ? this.insertHandler.insertItem(slot, stack, simulate) : stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return slot >= this.insertHandler.getSlots() ? this.extractHandler.extractItem(slot - this.insertHandler.getSlots(), amount, simulate) : ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return slot < this.insertHandler.getSlots() ? this.insertHandler.getSlotLimit(slot) : this.extractHandler.getSlotLimit(slot - this.insertHandler.getSlots());
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot < this.insertHandler.getSlots() ? this.insertHandler.isItemValid(slot, stack) : this.extractHandler.isItemValid(slot - this.extractHandler.getSlots(), stack);
    }
}

