/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.tooltip;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class SmallText {
    public static final float DEFAULT_SCALE = 0.5f;
    public static final float TOOLTIP_SCALE = 0.7f;

    private SmallText() {
    }

    public static float correctScale(float smallScale) {
        return SmallText.isSmall() ? smallScale : 1.0f;
    }

    public static boolean isSmall() {
        return !Minecraft.getInstance().isEnforceUnicode();
    }

    public static void render(Font font, FormattedCharSequence text, int x, int y, Matrix4f pose, MultiBufferSource.BufferSource buffer, float smallScale) {
        SmallText.render(font, text, x, y, -1, pose, buffer, smallScale);
    }

    public static void render(Font font, FormattedCharSequence text, int x, int y, int color, Matrix4f pose, MultiBufferSource.BufferSource buffer, float smallScale) {
        float scale = SmallText.correctScale(smallScale);
        Matrix4f scaled = new Matrix4f((Matrix4fc)pose);
        scaled.scale(scale, scale, 1.0f);
        font.drawInBatch(text, (float)x / scale, (float)y / scale + 1.0f, color, true, scaled, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void render(GuiGraphics graphics, Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow, float smallScale) {
        float scale = SmallText.correctScale(smallScale);
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 1.0f);
        graphics.drawString(font, text, (int)((float)x / scale), (int)((float)y / scale) + 1, color, dropShadow);
        graphics.pose().popPose();
    }

    public static void render(GuiGraphics graphics, Font font, String text, int x, int y, int color, boolean dropShadow, float smallScale) {
        float scale = SmallText.correctScale(smallScale);
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 1.0f);
        graphics.drawString(font, text, (int)((float)x / scale), (int)((float)y / scale) + 1, color, dropShadow);
        graphics.pose().popPose();
    }
}

