/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.tooltip;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class MouseClientTooltipComponent
implements ClientTooltipComponent {
    private static final int PADDING = 4;
    private final Type type;
    private final IconRenderer iconRenderer;
    @Nullable
    private final String amount;

    private MouseClientTooltipComponent(Type type, IconRenderer iconRenderer, @Nullable String amount) {
        this.type = type;
        this.iconRenderer = iconRenderer;
        this.amount = amount;
    }

    public static ClientTooltipComponent fluid(Type type, FluidResource fluidResource, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, (graphics, x, y) -> Platform.INSTANCE.getFluidRenderer().render(graphics.pose(), x, y, fluidResource), amount);
    }

    public static ClientTooltipComponent item(Type type, ItemStack stack, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, (graphics, x, y) -> graphics.renderItem(stack, x, y), amount);
    }

    public static ClientTooltipComponent itemWithDecorations(Type type, ItemStack stack, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, (graphics, x, y) -> {
            graphics.renderItem(stack, x, y);
            graphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y);
        }, amount);
    }

    public static ClientTooltipComponent itemConversion(Type type, final ItemStack from, final ItemStack to, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, new IconRenderer(){

            @Override
            public void render(GuiGraphics graphics, int x, int y) {
                graphics.renderItem(from, x, y);
                graphics.blitSprite(Sprites.LIGHT_ARROW, x + 16 + 2, y, 22, 15);
                graphics.renderItem(to, x + 16 + 2 + 22 + 2, y);
            }

            @Override
            public int getWidth() {
                return 58;
            }
        }, amount);
    }

    public static ClientTooltipComponent resource(Type type, ResourceKey resource, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, (graphics, x, y) -> RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass()).render(resource, graphics, x, y), amount);
    }

    public int getHeight() {
        return 18;
    }

    public int getWidth(Font font) {
        return 13 + this.iconRenderer.getWidth();
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        graphics.blitSprite(this.type.texture, x + this.type.leftPad, y, this.type.width, this.type.height);
        this.iconRenderer.render(graphics, x + 9 + 4, y);
        if (this.amount != null) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 200.0f);
            graphics.drawString(font, this.amount, x + 9 + 4 + 16 - font.width(this.amount), y + 9, 0xFFFFFF, true);
            poseStack.popPose();
        }
    }

    public static enum Type {
        LEFT(IdentifierUtil.createIdentifier("left_mouse_button"), 0, 9, 13),
        RIGHT(IdentifierUtil.createIdentifier("right_mouse_button"), 2, 9, 13);

        private final ResourceLocation texture;
        private final int leftPad;
        private final int width;
        private final int height;

        private Type(ResourceLocation texture, int leftPad, int width, int height) {
            this.texture = texture;
            this.leftPad = leftPad;
            this.width = width;
            this.height = height;
        }
    }

    private static interface IconRenderer {
        public void render(GuiGraphics var1, int var2, int var3);

        default public int getWidth() {
            return 16;
        }
    }
}

