/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DiskInventory
extends FilteredContainer
implements AbstractStorageContainerNetworkNode.Provider {
    private static final String TAG_DISK_STATE = "s";
    private static final String TAG_DISK_ITEM_ID = "i";
    private final DiskListener listener;
    @Nullable
    private StorageRepository storageRepository;

    public DiskInventory(DiskListener listener, int diskCount) {
        super(diskCount, StorageContainerItem.stackValidator());
        this.listener = listener;
    }

    public void setStorageRepository(@Nullable StorageRepository storageRepository) {
        this.storageRepository = storageRepository;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack result = super.removeItem(slot, amount);
        this.listener.onDiskChanged(this, slot);
        return result;
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.listener.onDiskChanged(this, slot);
    }

    @Override
    public Optional<Storage> resolve(int index) {
        if (this.storageRepository == null) {
            return Optional.empty();
        }
        return this.validateAndGetStack(index).flatMap(stack -> ((StorageContainerItem)stack.getItem()).resolve(this.storageRepository, (ItemStack)stack));
    }

    private Optional<ItemStack> validateAndGetStack(int slot) {
        ItemStack stack = this.getItem(slot);
        if (stack.isEmpty() || !(stack.getItem() instanceof StorageContainerItem)) {
            return Optional.empty();
        }
        return Optional.of(stack);
    }

    public ListTag toSyncTag(IntFunction<StorageState> stateProvider) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            CompoundTag disk = new CompoundTag();
            disk.putByte(TAG_DISK_STATE, (byte)stateProvider.apply(i).ordinal());
            ItemStack diskItem = this.getItem(i);
            if (!diskItem.isEmpty()) {
                disk.putInt(TAG_DISK_ITEM_ID, BuiltInRegistries.ITEM.getId((Object)diskItem.getItem()));
            }
            list.add((Object)disk);
        }
        return list;
    }

    public Disk[] fromSyncTag(ListTag list) {
        Disk[] disks = new Disk[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag diskTag = list.getCompound(i);
            disks[i] = BuiltInRegistries.ITEM.getHolder(diskTag.getInt(TAG_DISK_ITEM_ID)).map(item -> new Disk((Item)item.value(), this.getState(diskTag))).orElse(new Disk(null, StorageState.NONE));
        }
        return disks;
    }

    private StorageState getState(CompoundTag tag) {
        byte stateOrdinal = tag.getByte(TAG_DISK_STATE);
        StorageState[] values = StorageState.values();
        if (stateOrdinal < 0 || stateOrdinal >= values.length) {
            return StorageState.NONE;
        }
        return values[stateOrdinal];
    }

    @FunctionalInterface
    public static interface DiskListener {
        public void onDiskChanged(DiskInventory var1, int var2);
    }
}

