/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.iface;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.iface.InterfaceBlockEntity;
import com.refinedmods.refinedstorage.common.iface.InterfaceData;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public class InterfaceContainerMenu
extends AbstractResourceContainerMenu
implements ExportingIndicatorListener {
    private static final int EXPORT_CONFIG_SLOT_X = 8;
    private static final int EXPORT_CONFIG_SLOT_Y = 20;
    private static final int EXPORT_OUTPUT_SLOT_Y = 66;
    private final ExportingIndicators indicators;
    private final Predicate<Player> stillValid;

    InterfaceContainerMenu(int syncId, Player player, InterfaceBlockEntity blockEntity, ResourceContainer exportConfig, ResourceContainer exportedResources, Container exportedResourcesAsContainer, UpgradeContainer upgradeContainer, ExportingIndicators indicators) {
        super(Menus.INSTANCE.getInterface(), syncId, player);
        this.addSlots(player, exportConfig, exportedResources, exportedResourcesAsContainer, upgradeContainer);
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, blockEntity::getRedstoneMode, blockEntity::setRedstoneMode));
        this.indicators = indicators;
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)blockEntity, (Player)p);
    }

    public InterfaceContainerMenu(int syncId, Inventory playerInventory, InterfaceData interfaceData) {
        super(Menus.INSTANCE.getInterface(), syncId);
        ResourceContainer filterContainer = InterfaceBlockEntity.createFilterContainer(interfaceData);
        ResourceContainer exportedResources = InterfaceBlockEntity.createExportedResourcesContainer(interfaceData, FilterWithFuzzyMode.create(filterContainer, null));
        this.addSlots(playerInventory.player, filterContainer, exportedResources, exportedResources.toItemContainer(), new UpgradeContainer((UpgradeDestination)UpgradeDestinations.INTERFACE, 1));
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, false));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.indicators = new ExportingIndicators(interfaceData.exportingIndicators());
        this.stillValid = p -> true;
    }

    private void addSlots(Player player, ResourceContainer exportConfig, ResourceContainer exportedResources, Container exportedResourcesAsContainer, UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < exportConfig.size(); ++i) {
            this.addSlot(this.createExportConfigSlot(exportConfig, i));
        }
        for (i = 0; i < exportedResources.size(); ++i) {
            this.addSlot(this.addExportedResourceSlot(exportedResources, exportedResourcesAsContainer, i));
        }
        this.addSlot(new UpgradeSlot(upgradeContainer, 0, 187, 6));
        this.addPlayerInventory(player.getInventory(), 8, 100);
        this.transferManager.addBiTransfer(exportedResourcesAsContainer, (Container)player.getInventory());
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createExportConfigSlot(ResourceContainer exportConfig, int index) {
        int x = InterfaceContainerMenu.getExportSlotX(index);
        return new ResourceSlot(exportConfig, index, (Component)IdentifierUtil.createTranslation("gui", "interface.filter_help"), x, 20, ResourceSlotType.FILTER_WITH_AMOUNT);
    }

    private Slot addExportedResourceSlot(ResourceContainer exportedResources, Container exportedResourcesAsContainer, int index) {
        int x = InterfaceContainerMenu.getExportSlotX(index);
        return new ResourceSlot(exportedResources, exportedResourcesAsContainer, index, (Component)Component.empty(), x, 66, ResourceSlotType.CONTAINER);
    }

    ExportingIndicator getIndicator(int idx) {
        return this.indicators.get(idx);
    }

    int getIndicators() {
        return this.indicators.size();
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.indicators.detectChanges(serverPlayer);
        }
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }

    @Override
    public void indicatorChanged(int index, ExportingIndicator indicator) {
        this.indicators.set(index, indicator);
    }

    private static int getExportSlotX(int index) {
        return 8 + 18 * index;
    }
}

