/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.view;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.AbstractGridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResourceAttributeKey;
import com.refinedmods.refinedstorage.common.api.support.resource.FluidOperationResult;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FluidGridResource
extends AbstractGridResource<FluidResource> {
    private static final ItemStack EMPTY_BUCKET = new ItemStack((ItemLike)Items.BUCKET);
    private final int id;
    private final ResourceRendering rendering;

    public FluidGridResource(FluidResource resource, String name, Function<GridResourceAttributeKey, Set<String>> attributes) {
        super(resource, name, attributes);
        this.id = BuiltInRegistries.FLUID.getId((Object)resource.fluid());
        this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(FluidResource.class);
    }

    @Override
    public int getRegistryId() {
        return this.id;
    }

    @Override
    public List<ClientTooltipComponent> getExtractionHints(ItemStack carriedStack, ResourceRepository<GridResource> repository) {
        return this.tryFillFluidContainer(carriedStack).filter(result -> result.amount() > 0L).map(result -> MouseClientTooltipComponent.item(MouseClientTooltipComponent.Type.LEFT, result.container(), null)).stream().toList();
    }

    @Override
    @Nullable
    public ResourceAmount getAutocraftingRequest() {
        return new ResourceAmount(this.resource, Platform.INSTANCE.getBucketAmount());
    }

    private Optional<FluidOperationResult> tryFillFluidContainer(ItemStack carriedStack) {
        ResourceAmount toFill = new ResourceAmount(this.resource, Platform.INSTANCE.getBucketAmount());
        return carriedStack.isEmpty() ? Platform.INSTANCE.fillContainer(EMPTY_BUCKET, toFill) : Platform.INSTANCE.fillContainer(carriedStack, toFill);
    }

    @Override
    public boolean canExtract(ItemStack carriedStack, ResourceRepository<GridResource> repository) {
        if (this.getAmount(repository) == 0L) {
            return false;
        }
        if (carriedStack.isEmpty()) {
            return true;
        }
        ResourceAmount toFill = new ResourceAmount(this.resource, repository.getAmount(this.resource));
        return Platform.INSTANCE.fillContainer(carriedStack, toFill).map(result -> result.amount() > 0L).orElse(false);
    }

    @Override
    public void onExtract(GridExtractMode extractMode, boolean cursor, GridExtractionStrategy extractionStrategy) {
        extractionStrategy.onExtract(this.resource, extractMode, cursor);
    }

    @Override
    public void onScroll(GridScrollMode scrollMode, GridScrollingStrategy scrollingStrategy) {
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        Platform.INSTANCE.getFluidRenderer().render(graphics.pose(), x, y, (FluidResource)this.resource);
    }

    @Override
    public String getDisplayedAmount(ResourceRepository<GridResource> repository) {
        return this.rendering.formatAmount(this.getAmount(repository), true);
    }

    @Override
    public String getAmountInTooltip(ResourceRepository<GridResource> repository) {
        return this.rendering.formatAmount(this.getAmount(repository));
    }

    @Override
    public boolean belongsToResourceType(ResourceType resourceType) {
        return resourceType == ResourceTypes.FLUID;
    }

    @Override
    public List<Component> getTooltip() {
        return Platform.INSTANCE.getFluidRenderer().getTooltip((FluidResource)this.resource);
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return Optional.empty();
    }
}

