/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

class FluidBreakDestructorStrategy
implements DestructorStrategy {
    private final ServerLevel level;
    private final BlockPos pos;

    FluidBreakDestructorStrategy(ServerLevel level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    @Override
    public boolean apply(Filter filter, Actor actor, Supplier<Network> networkProvider, Player player) {
        LiquidBlock liquidBlock;
        BlockState blockState;
        block6: {
            block5: {
                if (!this.level.isLoaded(this.pos)) {
                    return false;
                }
                blockState = this.level.getBlockState(this.pos);
                Block block = blockState.getBlock();
                if (!(block instanceof LiquidBlock)) break block5;
                liquidBlock = (LiquidBlock)block;
                if ((Integer)blockState.getValue((Property)LiquidBlock.LEVEL) == 0) break block6;
            }
            return false;
        }
        Fluid fluid = blockState.getFluidState().getType();
        FluidResource fluidResource = new FluidResource(fluid);
        if (!filter.isAllowed(fluidResource)) {
            return false;
        }
        return this.tryInsert(actor, networkProvider, player, blockState, liquidBlock, fluidResource);
    }

    private boolean tryInsert(Actor actor, Supplier<Network> networkSupplier, Player actingPlayer, BlockState blockState, LiquidBlock liquidBlock, FluidResource fluidResource) {
        long amount = Platform.INSTANCE.getBucketAmount();
        long inserted = this.getRootStorage(networkSupplier).insert(fluidResource, amount, Action.SIMULATE, actor);
        if (inserted != amount) {
            return false;
        }
        this.level.setBlock(this.pos, Blocks.AIR.defaultBlockState(), 11);
        Platform.INSTANCE.getBucketPickupSound(liquidBlock, blockState).ifPresent(sound -> this.level.playSound(null, this.pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f));
        this.level.gameEvent((Entity)actingPlayer, (Holder)GameEvent.FLUID_PICKUP, this.pos);
        this.getRootStorage(networkSupplier).insert(fluidResource, amount, Action.EXECUTE, actor);
        return true;
    }

    private RootStorage getRootStorage(Supplier<Network> networkSupplier) {
        return networkSupplier.get().getComponent(StorageNetworkComponent.class);
    }
}

