/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.api.core.NullableType;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;

class StonecutterInputContainer
extends SimpleContainer
implements ContainerListener {
    private List<RecipeHolder<StonecutterRecipe>> recipes = Collections.emptyList();
    private final Supplier<Level> levelSupplier;
    private int selectedRecipe;

    StonecutterInputContainer(Supplier<@NullableType Level> levelSupplier) {
        super(1);
        this.levelSupplier = levelSupplier;
        this.addListener(this);
    }

    List<RecipeHolder<StonecutterRecipe>> getRecipes() {
        return this.recipes;
    }

    int getSelectedRecipe() {
        return this.selectedRecipe;
    }

    boolean hasSelectedRecipe() {
        return this.selectedRecipe >= 0;
    }

    void setSelectedRecipe(int idx) {
        this.selectedRecipe = idx;
    }

    public void containerChanged(Container container) {
        Level level = this.levelSupplier.get();
        if (level == null) {
            return;
        }
        this.selectedRecipe = -1;
        this.updateRecipes(level);
    }

    void updateRecipes(Level level) {
        ItemStack input = this.getItem(0);
        if (input.isEmpty()) {
            this.recipes = Collections.emptyList();
            return;
        }
        this.recipes = level.getRecipeManager().getRecipesFor(RecipeType.STONECUTTING, (RecipeInput)new SingleRecipeInput(input), level);
    }
}

