/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class ProcessingMatrixInputClientTooltipComponent
implements ClientTooltipComponent {
    private static final long CYCLE_MS = 1000L;
    private static final MutableComponent ALLOWED_ALTERNATIVES = IdentifierUtil.createTranslation("gui", "pattern_grid.processing.allowed_alternatives").withStyle(ChatFormatting.YELLOW);
    private static final int PADDING = 2;
    private final List<ResourceTag> allowedAlternatives;
    private final int width;
    private final int height;
    private final List<Component> names;
    private long cycleStart = 0L;
    private int currentCycle = 0;

    ProcessingMatrixInputClientTooltipComponent(PlatformResourceKey resource, Set<ResourceLocation> allowedAlternativeIds) {
        this.allowedAlternatives = resource.getTags().stream().filter(tag -> allowedAlternativeIds.contains(tag.key().location())).toList();
        this.names = this.allowedAlternatives.stream().map(ProcessingMatrixInputClientTooltipComponent::getName).toList();
        int totalWidth = 0;
        for (Component name : this.names) {
            totalWidth = Math.max(totalWidth, 20 + Minecraft.getInstance().font.width((FormattedText)name));
        }
        this.width = totalWidth;
        this.height = 11 + 18 * this.allowedAlternatives.size() + 3;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        long now = System.currentTimeMillis();
        if (this.cycleStart == 0L) {
            this.cycleStart = now;
        }
        if (now - this.cycleStart >= 1000L) {
            ++this.currentCycle;
            this.cycleStart = now;
        }
        graphics.drawString(font, (Component)ALLOWED_ALTERNATIVES, x, y, 0xFFFFFF);
        for (int i = 0; i < this.allowedAlternatives.size(); ++i) {
            ResourceTag alternative = this.allowedAlternatives.get(i);
            PlatformResourceKey resource = alternative.resources().get(this.currentCycle % alternative.resources().size());
            ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
            rendering.render(resource, graphics, x, y + 9 + 2 + i * 18);
            graphics.drawString(font, this.names.get(i), x + 18 + 2, y + 9 + 2 + i * 18 + 9 - 4, 0xAAAAAA);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth(Font font) {
        return this.width;
    }

    private static Component getName(ResourceTag alternative) {
        String translationKey = IdentifierUtil.getTagTranslationKey(alternative.key());
        boolean hasTranslation = I18n.exists((String)translationKey);
        return hasTranslation ? Component.translatable((String)translationKey) : Component.literal((String)alternative.key().location().toString());
    }
}

