/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitor;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorData;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.WirelessAutocraftingMonitorContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

class WirelessAutocraftingMonitorExtendedMenuProvider
implements ExtendedMenuProvider<AutocraftingMonitorData> {
    private final Component name;
    private final AutocraftingMonitor autocraftingMonitor;

    WirelessAutocraftingMonitorExtendedMenuProvider(Component name, AutocraftingMonitor autocraftingMonitor) {
        this.name = name;
        this.autocraftingMonitor = autocraftingMonitor;
    }

    @Override
    public AutocraftingMonitorData getMenuData() {
        return new AutocraftingMonitorData(this.autocraftingMonitor.getStatuses(), this.autocraftingMonitor.isAutocraftingMonitorActive());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, AutocraftingMonitorData> getMenuCodec() {
        return AutocraftingMonitorData.STREAM_CODEC;
    }

    public Component getDisplayName() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new WirelessAutocraftingMonitorContainerMenu(syncId, inventory, this.autocraftingMonitor);
    }
}

