/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.autocrafting.PatternSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterPrioritySideButtonWidget;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterPropertyTypes;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.VisibleToTheAutocrafterManagerSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.AbstractFilterScreen;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AutocrafterScreen
extends AbstractBaseScreen<AutocrafterContainerMenu>
implements AutocrafterContainerMenu.Listener,
PatternOutputRenderingScreen {
    private static final Component EMPTY_PATTERN_SLOT = IdentifierUtil.createTranslationAsHeading("gui", "autocrafter.empty_pattern_slot");
    private static final Component CHAINED = IdentifierUtil.createTranslation("gui", "autocrafter.chained");
    private static final Component CHAINED_HELP = IdentifierUtil.createTranslation("gui", "autocrafter.chained.help");
    private static final Component CHAINED_HEAD_HELP = IdentifierUtil.createTranslation("gui", "autocrafter.chained.head_help");
    private static final Component NOT_CHAINED = IdentifierUtil.createTranslation("gui", "autocrafter.not_chained");
    private static final Component NOT_CHAINED_HELP = IdentifierUtil.createTranslation("gui", "autocrafter.not_chained.help");
    private static final Component EDIT = IdentifierUtil.createTranslation("gui", "autocrafter.edit_name");
    private static final Component CURRENTLY_LOCKED = IdentifierUtil.createTranslation("gui", "autocrafter.currently_locked");
    private static final ResourceLocation NAME_BACKGROUND = IdentifierUtil.createIdentifier("widget/autocrafter_name");
    private static final List<String> CRAFTER_NAME_HISTORY = new ArrayList<String>();
    private final Inventory playerInventory;
    @Nullable
    private LockModeSideButtonWidget lockModeSideButtonWidget;
    @Nullable
    private EditBox nameField;
    @Nullable
    private Button editButton;
    private boolean editName;

    public AutocrafterScreen(AutocrafterContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, new TextMarquee(title, AutocrafterScreen.getTitleMaxWidth(menu)));
        this.inventoryLabelY = 42;
        this.imageWidth = 210;
        this.imageHeight = 137;
        this.playerInventory = playerInventory;
    }

    private static int getTitleMaxWidth(AutocrafterContainerMenu menu) {
        int chainingTitleWidth = Minecraft.getInstance().font.width((FormattedText)AutocrafterScreen.getChainingTitle(menu));
        int editButtonWidth = AutocrafterScreen.getEditButtonWidth();
        return 162 - chainingTitleWidth - editButtonWidth - 10;
    }

    private int getEditButtonX() {
        return this.leftPos + this.titleLabelX + this.titleMarquee.getEffectiveWidth(this.font) + 2;
    }

    private static int getEditButtonWidth() {
        return Minecraft.getInstance().font.width((FormattedText)EDIT) + 8;
    }

    private static Component getChainingTitle(AutocrafterContainerMenu menu) {
        return menu.isPartOfChain() || menu.isHeadOfChain() ? CHAINED : NOT_CHAINED;
    }

    private Component getChainingTooltip() {
        if (!((AutocrafterContainerMenu)this.getMenu()).isPartOfChain() && !((AutocrafterContainerMenu)this.getMenu()).isHeadOfChain()) {
            return NOT_CHAINED_HELP;
        }
        return ((AutocrafterContainerMenu)this.getMenu()).isHeadOfChain() ? CHAINED_HEAD_HELP : CHAINED_HELP;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        if (this.editName) {
            graphics.blitSprite(NAME_BACKGROUND, this.leftPos + 7, this.topPos + 5, 162, 12);
        }
    }

    @Override
    protected void init() {
        super.init();
        ((AutocrafterContainerMenu)this.getMenu()).setListener(this);
        this.tryAddLockModeSideButton();
        this.addSideButton(new AutocrafterPrioritySideButtonWidget(((AutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.PRIORITY), this.playerInventory, (Screen)this));
        this.addSideButton(new VisibleToTheAutocrafterManagerSideButtonWidget(((AutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER)));
        this.nameField = new SearchFieldWidget(this.font, this.leftPos + 8 + 1, this.topPos + 6 + 1, 153, new History(CRAFTER_NAME_HISTORY));
        this.nameField.setValue(this.title.getString());
        this.nameField.setBordered(false);
        this.nameField.setCanLoseFocus(false);
        this.addWidget((GuiEventListener)this.nameField);
        this.editButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)EDIT, button -> this.setEditName(true)).pos(this.getEditButtonX(), this.topPos + this.titleLabelY - 3).size(AutocrafterScreen.getEditButtonWidth(), 14).build());
        this.editButton.active = ((AutocrafterContainerMenu)this.getMenu()).canChangeName();
        this.setEditName(false);
    }

    private void tryAddLockModeSideButton() {
        if (((AutocrafterContainerMenu)this.getMenu()).isPartOfChain()) {
            return;
        }
        this.lockModeSideButtonWidget = new LockModeSideButtonWidget(((AutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.LOCK_MODE));
        this.lockedChanged(((AutocrafterContainerMenu)this.getMenu()).isLocked());
        this.addSideButton(this.lockModeSideButtonWidget);
    }

    private void setEditName(boolean editName) {
        this.editName = editName;
        if (this.nameField != null) {
            this.nameField.visible = editName;
            this.nameField.setFocused(editName);
            this.nameField.setCanLoseFocus(!editName);
            if (editName) {
                this.setFocused((GuiEventListener)this.nameField);
            } else {
                this.setFocused(null);
            }
        }
        if (this.editButton != null) {
            this.editButton.visible = !editName;
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.nameField != null && this.editName) {
            this.nameField.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.editName) {
            this.renderPlayerInventoryTitle(graphics);
            return;
        }
        super.renderLabels(graphics, mouseX, mouseY);
        Component title = AutocrafterScreen.getChainingTitle((AutocrafterContainerMenu)this.menu);
        graphics.drawString(this.font, title, this.getChainingTitleX(title), this.titleLabelY, 0x404040, false);
    }

    private int getChainingTitleX(Component title) {
        return this.imageWidth - 41 - this.font.width((FormattedText)title);
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.nameField != null && this.editName && this.nameField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.nameField != null && this.editName) {
            if (this.nameField.isFocused() && this.saveOrCancel(key)) {
                return true;
            }
            return this.nameField.keyPressed(key, scanCode, modifiers);
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    private boolean saveOrCancel(int key) {
        if (key == 257 || key == 335) {
            ((AutocrafterContainerMenu)this.getMenu()).changeName(Objects.requireNonNull(this.nameField).getValue());
            this.setEditName(false);
            return true;
        }
        if (key == 256) {
            this.setEditName(false);
            Objects.requireNonNull(this.nameField).setValue(this.titleMarquee.getText().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        PatternSlot patternSlot;
        Slot slot = this.hoveredSlot;
        if (slot instanceof PatternSlot && !(patternSlot = (PatternSlot)slot).hasItem() && ((AutocrafterContainerMenu)this.getMenu()).getCarried().isEmpty()) {
            graphics.renderTooltip(this.font, EMPTY_PATTERN_SLOT, x, y);
            return;
        }
        Component chainingTitle = AutocrafterScreen.getChainingTitle((AutocrafterContainerMenu)this.getMenu());
        int chainingTitleX = this.getChainingTitleX(chainingTitle);
        int n = this.font.width((FormattedText)chainingTitle);
        Objects.requireNonNull(this.font);
        if (this.isHovering(chainingTitleX, this.titleLabelY, n, 9, x, y)) {
            Component chainingTooltip = this.getChainingTooltip();
            Platform.INSTANCE.renderTooltip(graphics, List.of(HelpClientTooltipComponent.createAlwaysDisplayed(chainingTooltip)), x, y);
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    @Override
    protected ResourceLocation getTexture() {
        return AbstractFilterScreen.TEXTURE;
    }

    @Override
    public void nameChanged(Component name) {
        this.titleMarquee.setText(name);
        if (this.nameField != null) {
            this.nameField.setValue(name.getString());
        }
        if (this.editButton != null) {
            this.editButton.setX(this.getEditButtonX());
        }
    }

    @Override
    public void lockedChanged(boolean locked) {
        if (this.lockModeSideButtonWidget == null) {
            return;
        }
        if (locked) {
            this.lockModeSideButtonWidget.setWarning(CURRENTLY_LOCKED);
            return;
        }
        this.lockModeSideButtonWidget.setWarning(null);
    }

    @Override
    public boolean canDisplayOutput(ItemStack stack) {
        return ((AutocrafterContainerMenu)this.getMenu()).containsPattern(stack);
    }
}

