/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TaskCompletedToast
implements Toast {
    private static final ResourceLocation SPRITE = IdentifierUtil.createIdentifier("autocrafting_task_completed_toast");
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("misc", "autocrafting_task_completed");
    private static final long TIME_VISIBLE = 5000L;
    private static final int MARGIN = 4;
    private final ResourceKey resource;
    private final ResourceRendering rendering;
    private final MutableComponent resourceTitle;

    public TaskCompletedToast(ResourceKey resource, long amount) {
        this.resource = resource;
        this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        this.resourceTitle = Component.literal((String)this.rendering.formatAmount(amount, true)).append(" ").append(this.rendering.getDisplayName(resource));
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        graphics.blitSprite(SPRITE, 0, 0, this.width(), this.height());
        this.rendering.render(this.resource, graphics, 8, 8);
        Font font = Minecraft.getInstance().font;
        graphics.drawString(font, (Component)TITLE, 30, 7, -23296);
        graphics.drawString(font, (Component)this.resourceTitle, 30, 18, -1);
        return timeSinceLastVisible >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

