/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.task;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternType;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusBuilder;
import com.refinedmods.refinedstorage.api.autocrafting.task.AbstractTaskPattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalTaskPattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.InternalTaskPattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.PatternStepResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlan;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskImpl
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskImpl.class);
    private final TaskId id;
    private final ResourceKey resource;
    private final long amount;
    private final Actor actor;
    private final boolean notify;
    private final long startTime;
    private final Map<Pattern, AbstractTaskPattern> patterns;
    private final List<AbstractTaskPattern> completedPatterns = new ArrayList<AbstractTaskPattern>();
    private final MutableResourceList initialRequirements;
    private final MutableResourceList internalStorage;
    private TaskState state = TaskState.READY;
    private boolean cancelled;

    public TaskImpl(TaskSnapshot snapshot) {
        this.id = snapshot.id();
        this.resource = snapshot.resource();
        this.amount = snapshot.amount();
        this.actor = snapshot.actor();
        this.notify = snapshot.notifyActor();
        this.startTime = snapshot.startTime();
        this.patterns = snapshot.patterns().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TaskSnapshot.PatternSnapshot)e.getValue()).toTaskPattern(), (a, b) -> a, LinkedHashMap::new));
        snapshot.completedPatterns().forEach(patternSnapshot -> this.completedPatterns.add(patternSnapshot.toTaskPattern()));
        this.initialRequirements = snapshot.copyInitialRequirements();
        this.internalStorage = snapshot.copyInternalStorage();
        this.state = snapshot.state();
        this.cancelled = snapshot.cancelled();
    }

    public TaskImpl(TaskPlan plan, Actor actor, boolean notify) {
        this(plan, MutableResourceListImpl.create(), actor, notify);
    }

    TaskImpl(TaskPlan plan, MutableResourceList internalStorage, Actor actor, boolean notify) {
        this.id = TaskId.create();
        this.internalStorage = internalStorage;
        this.resource = plan.resource();
        this.amount = plan.amount();
        this.actor = actor;
        this.notify = notify;
        this.startTime = System.currentTimeMillis();
        this.patterns = plan.patterns().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> TaskImpl.createTaskPattern((Pattern)e.getKey(), (TaskPlan.PatternPlan)e.getValue()), (a, b) -> a, LinkedHashMap::new));
        this.initialRequirements = MutableResourceListImpl.create();
        plan.initialRequirements().forEach(this.initialRequirements::add);
    }

    private static AbstractTaskPattern createTaskPattern(Pattern pattern, TaskPlan.PatternPlan patternPlan) {
        return switch (pattern.layout().type()) {
            default -> throw new MatchException(null, null);
            case PatternType.INTERNAL -> new InternalTaskPattern(pattern, patternPlan);
            case PatternType.EXTERNAL -> new ExternalTaskPattern(pattern, patternPlan);
        };
    }

    @Override
    public Actor getActor() {
        return this.actor;
    }

    @Override
    public boolean shouldNotify() {
        return this.notify && !this.cancelled;
    }

    @Override
    public ResourceKey getResource() {
        return this.resource;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public TaskId getId() {
        return this.id;
    }

    @Override
    public TaskState getState() {
        return this.state;
    }

    private void updateState(TaskState newState) {
        LOGGER.debug("Task {} state changed from {} to {}", new Object[]{this.id.id(), this.state, newState});
        this.state = newState;
    }

    @Override
    public boolean step(RootStorage rootStorage, ExternalPatternSinkProvider sinkProvider, StepBehavior stepBehavior, TaskListener listener) {
        return switch (this.state) {
            default -> throw new MatchException(null, null);
            case TaskState.READY -> this.startTask(rootStorage);
            case TaskState.EXTRACTING_INITIAL_RESOURCES -> this.extractInitialResourcesAndTryStartRunningTask(rootStorage);
            case TaskState.RUNNING -> this.stepPatterns(rootStorage, sinkProvider, stepBehavior, listener);
            case TaskState.RETURNING_INTERNAL_STORAGE -> this.returnInternalStorageAndTryCompleteTask(rootStorage);
            case TaskState.COMPLETED -> false;
        };
    }

    @Override
    public void cancel() {
        this.state = TaskState.RETURNING_INTERNAL_STORAGE;
        this.cancelled = true;
    }

    @Override
    public TaskStatus getStatus() {
        TaskStatusBuilder builder = new TaskStatusBuilder(this.id, this.state, this.resource, this.amount, this.startTime);
        this.initialRequirements.getAll().forEach(requiredResource -> builder.extracting((ResourceKey)requiredResource, this.initialRequirements.get((ResourceKey)requiredResource)));
        double totalWeightedCompleted = 0.0;
        double totalWeight = 0.0;
        for (AbstractTaskPattern pattern : this.patterns.values()) {
            pattern.appendStatus(builder);
            totalWeightedCompleted += pattern.getPercentageCompleted() * (double)pattern.getWeight();
            totalWeight += (double)pattern.getWeight();
        }
        for (AbstractTaskPattern pattern : this.completedPatterns) {
            totalWeightedCompleted += (double)pattern.getWeight();
            totalWeight += (double)pattern.getWeight();
        }
        this.internalStorage.getAll().forEach(internalResource -> builder.stored((ResourceKey)internalResource, this.internalStorage.get((ResourceKey)internalResource)));
        return builder.build(totalWeight == 0.0 ? 0.0 : totalWeightedCompleted / totalWeight);
    }

    public TaskSnapshot createSnapshot() {
        return new TaskSnapshot(this.id, this.resource, this.amount, this.actor, this.notify, this.startTime, this.patterns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AbstractTaskPattern)e.getValue()).createSnapshot(), (a, b) -> a, LinkedHashMap::new)), this.completedPatterns.stream().filter(InternalTaskPattern.class::isInstance).map(InternalTaskPattern.class::cast).map(InternalTaskPattern::createSnapshot).toList(), this.initialRequirements.copy(), this.internalStorage.copy(), this.state, this.cancelled);
    }

    private boolean startTask(RootStorage rootStorage) {
        this.updateState(TaskState.EXTRACTING_INITIAL_RESOURCES);
        return this.extractInitialResourcesAndTryStartRunningTask(rootStorage);
    }

    private boolean extractInitialResourcesAndTryStartRunningTask(RootStorage rootStorage) {
        boolean extractedAll = true;
        boolean extractedAny = false;
        HashSet<ResourceKey> initialRequirementResources = new HashSet<ResourceKey>(this.initialRequirements.getAll());
        for (ResourceKey initialRequirementResource : initialRequirementResources) {
            long needed;
            long extracted = rootStorage.extract(initialRequirementResource, needed = this.initialRequirements.get(initialRequirementResource), Action.EXECUTE, Actor.EMPTY);
            if (extracted > 0L) {
                extractedAny = true;
            }
            LOGGER.debug("Extracted {}x {} from storage", (Object)extracted, (Object)initialRequirementResource);
            if (extracted != needed) {
                extractedAll = false;
            }
            if (extracted <= 0L) continue;
            this.initialRequirements.remove(initialRequirementResource, extracted);
            this.internalStorage.add(initialRequirementResource, extracted);
        }
        if (extractedAll) {
            this.updateState(TaskState.RUNNING);
        }
        return extractedAny;
    }

    private boolean stepPatterns(RootStorage rootStorage, ExternalPatternSinkProvider sinkProvider, StepBehavior stepBehavior, TaskListener listener) {
        Iterator<Map.Entry<Pattern, AbstractTaskPattern>> it = this.patterns.entrySet().iterator();
        boolean changed = false;
        while (it.hasNext()) {
            Map.Entry<Pattern, AbstractTaskPattern> pattern = it.next();
            PatternStepResult result = this.stepPattern(rootStorage, sinkProvider, stepBehavior, listener, pattern);
            if (result == PatternStepResult.COMPLETED) {
                it.remove();
            }
            changed |= result.isChanged();
        }
        if (this.patterns.isEmpty()) {
            if (this.internalStorage.isEmpty()) {
                this.updateState(TaskState.COMPLETED);
            } else {
                this.updateState(TaskState.RETURNING_INTERNAL_STORAGE);
            }
        }
        return changed;
    }

    private PatternStepResult stepPattern(RootStorage rootStorage, ExternalPatternSinkProvider sinkProvider, StepBehavior stepBehavior, TaskListener listener, Map.Entry<Pattern, AbstractTaskPattern> pattern) {
        PatternStepResult result = PatternStepResult.IDLE;
        if (!stepBehavior.canStep(pattern.getKey())) {
            return result;
        }
        int steps = stepBehavior.getSteps(pattern.getKey());
        for (int i = 0; i < steps; ++i) {
            PatternStepResult stepResult = pattern.getValue().step(this.internalStorage, rootStorage, sinkProvider, listener);
            if (stepResult == PatternStepResult.COMPLETED) {
                LOGGER.debug("{} completed", (Object)pattern.getKey());
                this.completedPatterns.add(pattern.getValue());
                return stepResult;
            }
            if (stepResult == PatternStepResult.IDLE) continue;
            result = PatternStepResult.RUNNING;
        }
        return result;
    }

    private boolean returnInternalStorageAndTryCompleteTask(RootStorage rootStorage) {
        boolean returnedAll = true;
        boolean returnedAny = false;
        HashSet<ResourceKey> internalResources = new HashSet<ResourceKey>(this.internalStorage.getAll());
        for (ResourceKey internalResource : internalResources) {
            long internalAmount;
            long inserted = rootStorage.insert(internalResource, internalAmount = this.internalStorage.get(internalResource), Action.EXECUTE, Actor.EMPTY);
            if (inserted > 0L) {
                returnedAny = true;
            }
            LOGGER.debug("Returned {}x {} into storage", (Object)inserted, (Object)internalResource);
            if (inserted != internalAmount) {
                returnedAll = false;
            }
            if (inserted <= 0L) continue;
            this.internalStorage.remove(internalResource, inserted);
        }
        if (returnedAll) {
            this.updateState(TaskState.COMPLETED);
        }
        return returnedAny;
    }

    @Override
    public long beforeInsert(ResourceKey insertedResource, long insertedAmount) {
        if (this.cancelled) {
            return 0L;
        }
        long intercepted = 0L;
        for (AbstractTaskPattern pattern : this.patterns.values()) {
            long available;
            if ((intercepted += pattern.beforeInsert(insertedResource, available = insertedAmount - intercepted)) != insertedAmount) continue;
            this.internalStorage.add(insertedResource, intercepted);
            return intercepted;
        }
        if (intercepted > 0L) {
            this.internalStorage.add(insertedResource, intercepted);
        }
        return intercepted;
    }

    @Override
    public long afterInsert(ResourceKey insertedResource, long insertedAmount) {
        long reserved = 0L;
        for (AbstractTaskPattern pattern : this.patterns.values()) {
            long available;
            if ((reserved += pattern.afterInsert(insertedResource, available = insertedAmount - reserved)) != insertedAmount) continue;
            return reserved;
        }
        return reserved;
    }

    @Override
    public void changed(MutableResourceList.OperationResult change) {
    }
}

