/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.craftability;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CalculationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsCraftableCraftingCalculatorListener
implements CraftingCalculatorListener<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsCraftableCraftingCalculatorListener.class);
    private boolean missingResources;

    private IsCraftableCraftingCalculatorListener() {
    }

    private IsCraftableCraftingCalculatorListener(boolean missingResources) {
        this.missingResources = missingResources;
    }

    private static boolean isCraftable(CraftingCalculator calculator, ResourceKey resource, long amount, CancellationToken cancellationToken) {
        IsCraftableCraftingCalculatorListener listener = new IsCraftableCraftingCalculatorListener();
        try {
            calculator.calculate(resource, amount, listener, cancellationToken);
        }
        catch (CancellationException e) {
            return false;
        }
        return !listener.missingResources;
    }

    public static long binarySearchMaxAmount(CraftingCalculator calculator, ResourceKey resource, CancellationToken cancellationToken) {
        try {
            LOGGER.debug("Finding max amount for {} starting from 1", (Object)resource);
            long low = 1L;
            long high = 1L;
            int calculationCount = 1;
            while (IsCraftableCraftingCalculatorListener.isCraftable(calculator, resource, high, cancellationToken)) {
                low = high;
                LOGGER.debug("Finding low and high for the craftable amount, currently between {} and {}", (Object)low, (Object)(high *= 2L));
                ++calculationCount;
            }
            if (low == high) {
                return 0L;
            }
            LOGGER.debug("Our craftable amount is between {} and {}", (Object)low, (Object)high);
            while (low < high) {
                long amount = low + (high - low + 1L) / 2L;
                LOGGER.debug("Trying {} (between {} and {})", new Object[]{amount, low, high});
                ++calculationCount;
                if (IsCraftableCraftingCalculatorListener.isCraftable(calculator, resource, amount, cancellationToken)) {
                    LOGGER.debug("{} was craftable, increasing our low amount", (Object)amount);
                    low = amount;
                    continue;
                }
                LOGGER.debug("{} is not craftable, decreasing our high amount", (Object)amount);
                high = amount - 1L;
            }
            LOGGER.debug("Found the maximum amount of {} in {} tries", (Object)low, (Object)calculationCount);
            return low;
        }
        catch (CalculationException e) {
            LOGGER.error("Error while calculating max amount for {}", (Object)resource, (Object)e);
            return 0L;
        }
    }

    @Override
    public CraftingCalculatorListener<Boolean> childCalculationStarted(Pattern childPattern, ResourceKey resource, Amount amount) {
        return new IsCraftableCraftingCalculatorListener(this.missingResources);
    }

    @Override
    public void childCalculationCompleted(CraftingCalculatorListener<Boolean> childListener) {
        this.missingResources = Objects.requireNonNull(childListener.getData());
    }

    @Override
    public void ingredientsExhausted(ResourceKey resource, long amount) {
        this.missingResources = true;
    }

    @Override
    public Boolean getData() {
        return this.missingResources;
    }

    @Override
    public boolean requiresFullMissingResourcesCalculation() {
        return false;
    }
}

