/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.network.IMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MessageSetFilterMode
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_filter_mode");
    public static final CustomPacketPayload.Type<MessageSetFilterMode> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetFilterMode> STREAM_CODEC = CustomPacketPayload.codec(MessageSetFilterMode::encode, MessageSetFilterMode::new);
    public boolean isBlacklistFilter;
    public int entityId;

    public MessageSetFilterMode(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetFilterMode(boolean isBlacklistFilter, int entityId) {
        this.isBlacklistFilter = isBlacklistFilter;
        this.entityId = entityId;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Entity e = player.level().getEntity(this.entityId);
        if (e instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)e;
            spirit.setFilterBlacklist(this.isBlacklistFilter);
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.isBlacklistFilter);
        buf.writeInt(this.entityId);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.isBlacklistFilter = buf.readBoolean();
        this.entityId = buf.readInt();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

