/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.waila;

import com.klikli_dev.occultism.common.entity.spirit.AfritEntity;
import com.klikli_dev.occultism.common.entity.spirit.DjinniEntity;
import com.klikli_dev.occultism.common.entity.spirit.FoliotEntity;
import com.klikli_dev.occultism.common.entity.spirit.MaridEntity;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class SpiritComponentProvider
implements IEntityComponentProvider {
    public static final SpiritComponentProvider INSTANCE = new SpiritComponentProvider();

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity;
        if (entityAccessor != null && (entity = entityAccessor.getEntity()) instanceof SpiritEntity) {
            SpiritEntity spiritEntity = (SpiritEntity)entity;
            int maxAge = spiritEntity.getSpiritMaxAge();
            int age = spiritEntity.getSpiritAge();
            String spiritType = this.getSpiritType(spiritEntity);
            if (spiritType != null) {
                if (maxAge != -1) {
                    iTooltip.add((Component)Component.translatable((String)("occultism.waila." + spiritType + "_age"), (Object[])new Object[]{maxAge - age}));
                } else {
                    iTooltip.add((Component)Component.translatable((String)("occultism.waila." + spiritType)));
                }
            }
            if (spiritEntity.getJobID() != null && !spiritEntity.getJobID().isEmpty()) {
                String job = spiritEntity.getJobID().split(":", 2)[1];
                iTooltip.add((Component)Component.translatable((String)("job.occultism." + job)));
            }
        }
    }

    private String getSpiritType(SpiritEntity spiritEntity) {
        if (spiritEntity instanceof FoliotEntity) {
            return "foliot";
        }
        if (spiritEntity instanceof DjinniEntity) {
            return "djinni";
        }
        if (spiritEntity instanceof AfritEntity) {
            return "afrit";
        }
        if (spiritEntity instanceof MaridEntity) {
            return "marid";
        }
        return null;
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"foliot");
    }
}

