/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;

public class HurtBySensor<E extends Mob>
extends PredicateSensor<DamageSource, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY});

    public HurtBySensor() {
        super((damageSource, entity) -> true);
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.HURT_BY.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        Brain brain = entity.getBrain();
        DamageSource damageSource = entity.getLastDamageSource();
        if (damageSource == null) {
            BrainUtils.clearMemory(brain, MemoryModuleType.HURT_BY);
            BrainUtils.clearMemory(brain, MemoryModuleType.HURT_BY_ENTITY);
        } else if (this.predicate().test(damageSource, entity)) {
            LivingEntity attacker2;
            BrainUtils.setMemory(brain, MemoryModuleType.HURT_BY, damageSource);
            Entity entity2 = damageSource.getEntity();
            if (entity2 instanceof LivingEntity && (attacker2 = (LivingEntity)entity2).isAlive() && attacker2.level() == entity.level()) {
                BrainUtils.setMemory(brain, MemoryModuleType.HURT_BY_ENTITY, attacker2);
            }
        } else {
            BrainUtils.withMemory(brain, MemoryModuleType.HURT_BY_ENTITY, attacker -> {
                if (!attacker.isAlive() || attacker.level() != entity.level()) {
                    BrainUtils.clearMemory(brain, MemoryModuleType.HURT_BY_ENTITY);
                }
            });
        }
    }
}

