/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.datagen;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.holdersets.AndHolderSet;
import net.neoforged.neoforge.registries.holdersets.OrHolderSet;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.world.content.generation.CaveGeyserStructure;
import tv.soaryn.xycraft.world.content.generation.SurfaceGeyserStructure;
import tv.soaryn.xycraft.world.content.registries.WorldContent;
import tv.soaryn.xycraft.world.content.registries.WorldStructures;
import tv.soaryn.xycraft.world.datagen.WorldBlockLoot;
import tv.soaryn.xycraft.world.datagen.WorldBlockStateDataGen;
import tv.soaryn.xycraft.world.datagen.WorldBlockTagDataGen;
import tv.soaryn.xycraft.world.datagen.WorldItemModelDataGen;
import tv.soaryn.xycraft.world.datagen.WorldItemTagDataGen;
import tv.soaryn.xycraft.world.datagen.WorldLanguageDataGen;
import tv.soaryn.xycraft.world.datagen.WorldRecipeDataGen;

@EventBusSubscriber(modid="xycraft_world", bus=EventBusSubscriber.Bus.MOD)
public interface WorldDataGenerator {
    public static final RegistrySetBuilder StructureRegistryBuilder = new RegistrySetBuilder().add(Registries.STRUCTURE, WorldDataGenerator::bootstrapStructures).add(Registries.STRUCTURE_SET, WorldDataGenerator::bootstrapStructureSets);

    public static void bootstrapStructures(BootstrapContext<Structure> context) {
        SimpleStateProvider surfaceWellspringProvider = BlockStateProvider.simple((Block)WorldContent.Block.Geyser.block());
        WeightedStateProvider caveWellspringProvider = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)WorldContent.Block.Geyser.block().defaultBlockState(), 3).add((Object)WorldContent.Block.Geyser.block().defaultBlockState(), 1).build());
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        AndHolderSet overworldSansWateryBiomes = new AndHolderSet(List.of(biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD), new OrHolderSet(List.of(biomeLookup.getOrThrow(Tags.Biomes.IS_DRY), biomeLookup.getOrThrow(Tags.Biomes.IS_MOUNTAIN), biomeLookup.getOrThrow(Tags.Biomes.IS_PLAINS), biomeLookup.getOrThrow(BiomeTags.IS_HILL), biomeLookup.getOrThrow(BiomeTags.IS_JUNGLE), biomeLookup.getOrThrow(BiomeTags.IS_FOREST), biomeLookup.getOrThrow(BiomeTags.IS_TAIGA), biomeLookup.getOrThrow(BiomeTags.IS_SAVANNA), biomeLookup.getOrThrow(BiomeTags.IS_BADLANDS), biomeLookup.getOrThrow(BiomeTags.IS_TAIGA), biomeLookup.getOrThrow(XyCraftTags.Biomes.ValidGeyserSpawn.tag())))));
        Structure.StructureSettings structureSettings = new Structure.StructureSettings((HolderSet)overworldSansWateryBiomes, Map.of(), GenerationStep.Decoration.LOCAL_MODIFICATIONS, TerrainAdjustment.BEARD_THIN);
        context.register(WorldStructures.SurfaceGeyser, (Object)new SurfaceGeyserStructure((BlockStateProvider)surfaceWellspringProvider, (FloatProvider)UniformFloat.of((float)5.6f, (float)5.7f), (FloatProvider)UniformFloat.of((float)5.6f, (float)5.7f), structureSettings));
        HolderSet.Named overworldWithoutSurface = biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD);
        Structure.StructureSettings caveOnlySettings = new Structure.StructureSettings((HolderSet)overworldWithoutSurface, Map.of(), GenerationStep.Decoration.LOCAL_MODIFICATIONS, TerrainAdjustment.NONE);
        context.register(WorldStructures.UndergroundGeyser, (Object)new CaveGeyserStructure((BlockStateProvider)caveWellspringProvider, (FloatProvider)UniformFloat.of((float)5.6f, (float)5.7f), (FloatProvider)UniformFloat.of((float)5.6f, (float)5.7f), caveOnlySettings));
    }

    public static void bootstrapStructureSets(BootstrapContext<StructureSet> context) {
        HolderGetter structureLookup = context.lookup(Registries.STRUCTURE);
        context.register(WorldStructures.HarvestableNodeSet, (Object)new StructureSet(List.of(new StructureSet.StructureSelectionEntry((Holder)structureLookup.getOrThrow(WorldStructures.SurfaceGeyser), 3), new StructureSet.StructureSelectionEntry((Holder)structureLookup.getOrThrow(WorldStructures.UndergroundGeyser), 1)), (StructurePlacement)new RandomSpreadStructurePlacement(15, 7, RandomSpreadType.TRIANGULAR, 918273645)));
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(true, (DataProvider)new WorldRecipeDataGen(output, lookup));
        if (event.includeServer()) {
            WorldBlockTagDataGen blockTag = new WorldBlockTagDataGen(output, lookup, "xycraft_world", existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTag);
            generator.addProvider(true, (DataProvider)new WorldItemTagDataGen(output, lookup, blockTag.contentsGetter(), "xycraft_world", existingFileHelper));
            generator.addProvider(true, (DataProvider)WorldBlockLoot.supplier(output, lookup));
            generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(output, lookup, StructureRegistryBuilder, Collections.singleton("xycraft_world")));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new WorldLanguageDataGen(output, "xycraft_world", "en_us"));
            generator.addProvider(true, (DataProvider)new WorldLanguageDataGen(output, "xycraft_world", "fi_fi"));
            generator.addProvider(true, (DataProvider)new WorldLanguageDataGen(output, "xycraft_world", "en_au"));
            generator.addProvider(true, (DataProvider)new WorldLanguageDataGen(output, "xycraft_world", "en_gb"));
            generator.addProvider(true, (DataProvider)new WorldBlockStateDataGen(output, WorldContent.Map, "xycraft_world", existingFileHelper));
            generator.addProvider(true, (DataProvider)new WorldItemModelDataGen(output, "xycraft_world", existingFileHelper));
        }
    }
}

