/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.generation;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.world.content.generation.CaveGeyserPiece;
import tv.soaryn.xycraft.world.content.generation.HarvestableNodeStructure;
import tv.soaryn.xycraft.world.content.registries.WorldStructures;

public class CaveGeyserStructure
extends HarvestableNodeStructure {
    public static final MapCodec<CaveGeyserStructure> CODEC = CaveGeyserStructure.makeCodec(CaveGeyserStructure::new);

    public CaveGeyserStructure(BlockStateProvider blockStateProvider, FloatProvider clearanceRadius, FloatProvider clearanceHeight, Structure.StructureSettings settings) {
        super(blockStateProvider, clearanceRadius, clearanceHeight, settings);
    }

    @Override
    protected Optional<BlockPos> getStartPos(Structure.GenerationContext context, WorldgenRandom random) {
        int placeX = SectionPos.sectionToBlockCoord((int)context.chunkPos().x);
        int placeZ = SectionPos.sectionToBlockCoord((int)context.chunkPos().z);
        int firstOccupiedHeight = context.chunkGenerator().getFirstOccupiedHeight(placeX, placeZ, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        return Optional.of(new BlockPos(placeX, firstOccupiedHeight - 32, placeZ));
    }

    @Override
    protected Consumer<StructurePiecesBuilder> createStructure(BlockPos center, BlockState blockWell, float radius, float height) {
        return structurePiecesBuilder -> structurePiecesBuilder.addPiece((StructurePiece)new CaveGeyserPiece(center, blockWell, radius, height));
    }

    @NotNull
    public StructureType<CaveGeyserStructure> type() {
        return (StructureType)WorldStructures.CaveGeyserType.value();
    }
}

