/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.misc.MiscDirs;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SlopePanelCornerDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabDirs;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsDirs;

@CullTest(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
public final class VerticalHalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            return switch (blockType) {
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfSlope(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstElevatedSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstCornerSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstElevatedInnerCornerSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstInnerThreewayCornerSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstSlab(dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstStairs(dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstHalfStairs(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstSlopedStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalStairs(dir, top, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> VerticalHalfStairsSkipPredicate.testAgainstThreewayCornerPillar(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstElevatedSlopeSlab(dir, top, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstCompoundSlopeSlab(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> VerticalHalfStairsSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> VerticalHalfStairsSkipPredicate.testAgainstLargeCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> VerticalHalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> VerticalHalfStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> VerticalHalfStairsSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> VerticalHalfStairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstElevatedPyramidSlab(dir, top, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> VerticalHalfStairsSkipPredicate.testAgainstMasonryCornerSegment(dir, top, adjState, side);
                case BlockType.FRAMED_CHECKERED_SLAB_SEGMENT -> VerticalHalfStairsSkipPredicate.testAgainstCheckeredSlabSegment(dir, top, adjState, side);
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> VerticalHalfStairsSkipPredicate.testAgainstCheckeredPanelSegment(dir, top, adjState, side);
                case BlockType.FRAMED_LAYERED_CUBE -> VerticalHalfStairsSkipPredicate.testAgainstLayeredCube(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(StairsDirs.VerticalHalfStairs.getStairDir(adjDir, adjTop, side.getOpposite())) || StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(StairsDirs.VerticalHalfStairs.getHalfDir(adjDir, adjTop, side.getOpposite())) || StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(StairsDirs.VerticalHalfStairs.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeDirs.VerticalHalfSlope.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeEdgeDirs.SlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlopeEdgeDirs.CornerSlopeEdge.getCornerDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(adjDir, adjType, adjAlt, side.getOpposite())) || StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite())) || StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedInnerCornerSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(SlopeEdgeDirs.ElevatedInnerCornerSlopeEdge.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerThreewayCornerSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(SlopeEdgeDirs.InnerThreewayCornerSlopeEdge.getStairDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlabDirs.Slab.getHalfDir(adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlabDirs.SlabEdge.getHalfDir(adjDir, adjTop, side.getOpposite())) || StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlabDirs.SlabEdge.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlabDirs.SlabCorner.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(StairsDirs.Stairs.getStairDir(adjDir, adjShape, adjHalf, side.getOpposite())) || StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(StairsDirs.Stairs.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(StairsDirs.HalfStairs.getCornerDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(StairsDirs.SlopedStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(StairsDirs.VerticalStairs.getStairDir(adjDir, adjType, side.getOpposite())) || StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(StairsDirs.VerticalStairs.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(PillarDirs.ThreewayCornerPillar.getStairDir(adjDir, adjTop, side.getOpposite())) || StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(PillarDirs.ThreewayCornerPillar.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeSlabDirs.SlopeSlab.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeSlabDirs.ElevatedSlopeSlab.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeSlabDirs.CompoundSlopeSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeSlabDirs.FlatElevatedSlopeSlabCorner.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlopePanelCornerDirs.SmallCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(SlopePanelCornerDirs.LargeCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlopePanelCornerDirs.SmallInnerCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(SlopePanelCornerDirs.LargeInnerCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getStairDir(dir, top, side).isEqualTo(SlopePanelCornerDirs.ExtendedInnerCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(SlopeDirs.ElevatedPyramidSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlabDirs.MasonryCornerSegment.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_SLAB_SEGMENT})
    private static boolean testAgainstCheckeredSlabSegment(Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlabDirs.CheckeredSlabSegment.getCornerDir(adjTop, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return StairsDirs.VerticalHalfStairs.getCornerDir(dir, top, side).isEqualTo(SlabDirs.CheckeredPanelSegment.getCornerDir(adjDir, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LAYERED_CUBE})
    private static boolean testAgainstLayeredCube(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjFacing = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        int adjLayers = (Integer)adjState.getValue((Property)BlockStateProperties.LAYERS);
        return StairsDirs.VerticalHalfStairs.getHalfDir(dir, top, side).isEqualTo(MiscDirs.LayeredCube.getHalfDir(adjFacing, adjLayers, side.getOpposite()));
    }
}

