/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.misc.MiscDirs;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SlopePanelCornerDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabDirs;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsDirs;

@CullTest(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
public final class ElevatedCornerSlopeEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
            return switch (blockType) {
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstVerticalHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstElevatedSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstCornerSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstElevatedInnerCornerSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_SLAB -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSlab(dir, type, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSlabEdge(dir, type, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSlabCorner(dir, type, adjState, side);
                case BlockType.FRAMED_PANEL -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstPanel(dir, type, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstCornerPillar(dir, type, adjState, side);
                case BlockType.FRAMED_STAIRS -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstStairs(dir, type, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstHalfStairs(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSlopedStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstVerticalStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstVerticalHalfStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstVerticalSlopedStairs(dir, type, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerPillar(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSlopeSlab(dir, type, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstElevatedSlopeSlab(dir, type, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstCompoundSlopeSlab(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstExtendedSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_PANEL -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstCompoundSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSmallCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstElevatedPyramidSlab(dir, type, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstMasonryCornerSegment(dir, type, adjState, side);
                case BlockType.FRAMED_CHECKERED_SLAB_SEGMENT -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstCheckeredSlabSegment(dir, type, adjState, side);
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstCheckeredPanelSegment(dir, type, adjState, side);
                case BlockType.FRAMED_LAYERED_CUBE -> ElevatedCornerSlopeEdgeSkipPredicate.testAgainstLayeredCube(dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getTriDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getTriDir(adjDir, adjType, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeDirs.HalfSlope.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeDirs.VerticalHalfSlope.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeEdgeDirs.SlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getTriDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getTriDir(adjDir, adjType, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlopeEdgeDirs.CornerSlopeEdge.getCornerDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedInnerCornerSlopeEdge(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getTriDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedInnerCornerSlopeEdge.getTriDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlabDirs.Slab.getHalfDir(adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlabDirs.SlabEdge.getHalfDir(adjDir, adjTop, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlabDirs.SlabEdge.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlabDirs.SlabCorner.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlabDirs.Panel.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(PillarDirs.CornerPillar.getHalfDir(adjDir, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(PillarDirs.CornerPillar.getCornerDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.Stairs.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(StairsDirs.Stairs.getCornerDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.HalfStairs.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(StairsDirs.HalfStairs.getCornerDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.SlopedStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.VerticalStairs.getHalfDir(adjDir, adjType, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(StairsDirs.VerticalStairs.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.VerticalHalfStairs.getHalfDir(adjDir, adjTop, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(StairsDirs.VerticalHalfStairs.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.VerticalSlopedStairs.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(PillarDirs.ThreewayCornerPillar.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.SlopeSlab.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.ElevatedSlopeSlab.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.CompoundSlopeSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.FlatElevatedSlopeSlabCorner.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.SlopePanel.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.ExtendedSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_PANEL})
    private static boolean testAgainstCompoundSlopePanel(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.CompoundSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.FlatInnerSlopePanelCorner.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.FlatExtendedSlopePanelCorner.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlopePanelCornerDirs.SmallCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlopePanelCornerDirs.SmallCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlopePanelCornerDirs.SmallInnerCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlopePanelCornerDirs.SmallInnerCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlopePanelCornerDirs.ExtendedCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeDirs.ElevatedPyramidSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlabDirs.MasonryCornerSegment.getHalfDir(adjDir, adjTop, side.getOpposite())) || SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlabDirs.MasonryCornerSegment.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_SLAB_SEGMENT})
    private static boolean testAgainstCheckeredSlabSegment(Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlabDirs.CheckeredSlabSegment.getCornerDir(adjTop, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(dir, type, side).isEqualTo(SlabDirs.CheckeredPanelSegment.getCornerDir(adjDir, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LAYERED_CUBE})
    private static boolean testAgainstLayeredCube(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjFacing = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        int adjLayers = (Integer)adjState.getValue((Property)BlockStateProperties.LAYERS);
        return SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(dir, type, side).isEqualTo(MiscDirs.LayeredCube.getHalfDir(adjFacing, adjLayers, side.getOpposite()));
    }
}

