/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.PillarConnection;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;

@CullTest(value={BlockType.FRAMED_PYRAMID}, noSelfTest=true)
public final class PyramidSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        PillarConnection connection;
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        if (SlopeDirs.Pyramid.testEarlyExit(dir, connection = (PillarConnection)((Object)state.getValue(PropertyHolder.PILLAR_CONNECTION)), side)) {
            return false;
        }
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            return switch (blockType) {
                case BlockType.FRAMED_WALL -> PyramidSkipPredicate.testAgainstWall(dir, connection, adjState, side);
                case BlockType.FRAMED_FENCE -> PyramidSkipPredicate.testAgainstFence(dir, connection, side);
                case BlockType.FRAMED_LATTICE_BLOCK -> PyramidSkipPredicate.testAgainstLattice(dir, connection, adjState, side);
                case BlockType.FRAMED_THICK_LATTICE -> PyramidSkipPredicate.testAgainstThickLattice(dir, connection, adjState, side);
                case BlockType.FRAMED_PILLAR -> PyramidSkipPredicate.testAgainstPillar(dir, connection, adjState, side);
                case BlockType.FRAMED_HALF_PILLAR -> PyramidSkipPredicate.testAgainstHalfPillar(dir, connection, adjState, side);
                case BlockType.FRAMED_POST -> PyramidSkipPredicate.testAgainstPost(dir, connection, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_WALL})
    private static boolean testAgainstWall(Direction dir, PillarConnection connection, BlockState adjState, Direction side) {
        boolean adjUp = (Boolean)adjState.getValue((Property)BlockStateProperties.UP);
        return SlopeDirs.Pyramid.isPillarDir(dir, connection, side) && PillarDirs.Wall.isPillarDir(adjUp, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE})
    private static boolean testAgainstFence(Direction dir, PillarConnection connection, Direction side) {
        return SlopeDirs.Pyramid.isPostDir(dir, connection, side) && PillarDirs.Fence.isPostDir(side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LATTICE_BLOCK})
    private static boolean testAgainstLattice(Direction dir, PillarConnection connection, BlockState adjState, Direction side) {
        boolean adjXAxis = (Boolean)adjState.getValue((Property)FramedProperties.X_AXIS);
        boolean adjYAxis = (Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS);
        boolean adjZAxis = (Boolean)adjState.getValue((Property)FramedProperties.Z_AXIS);
        return SlopeDirs.Pyramid.isPostDir(dir, connection, side) && PillarDirs.Lattice.isPostDir(adjXAxis, adjYAxis, adjZAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THICK_LATTICE})
    private static boolean testAgainstThickLattice(Direction dir, PillarConnection connection, BlockState adjState, Direction side) {
        boolean adjXAxis = (Boolean)adjState.getValue((Property)FramedProperties.X_AXIS);
        boolean adjYAxis = (Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS);
        boolean adjZAxis = (Boolean)adjState.getValue((Property)FramedProperties.Z_AXIS);
        return SlopeDirs.Pyramid.isPillarDir(dir, connection, side) && PillarDirs.ThickLattice.isPillarDir(adjXAxis, adjYAxis, adjZAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PILLAR})
    private static boolean testAgainstPillar(Direction dir, PillarConnection connection, BlockState adjState, Direction side) {
        Direction.Axis adjAxis = (Direction.Axis)adjState.getValue((Property)BlockStateProperties.AXIS);
        return SlopeDirs.Pyramid.isPillarDir(dir, connection, side) && PillarDirs.Pillar.isPillarDir(adjAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_PILLAR})
    private static boolean testAgainstHalfPillar(Direction dir, PillarConnection connection, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return SlopeDirs.Pyramid.isPillarDir(dir, connection, side) && PillarDirs.HalfPillar.isPillarDir(adjDir, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_POST})
    private static boolean testAgainstPost(Direction dir, PillarConnection connection, BlockState adjState, Direction side) {
        Direction.Axis adjAxis = (Direction.Axis)adjState.getValue((Property)BlockStateProperties.AXIS);
        return SlopeDirs.Pyramid.isPostDir(dir, connection, side) && PillarDirs.Post.isPostDir(adjAxis, side.getOpposite());
    }
}

