/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;
import xfacthd.framedblocks.common.data.property.DirectionAxis;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.prism.PrismDirs;

@CullTest(value={BlockType.FRAMED_ELEVATED_INNER_PRISM})
public final class ElevatedInnerPrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.getValue(PropertyHolder.FACING_AXIS));
        if (PrismDirs.ElevatedInnerPrism.testEarlyExit(dirAxis, side)) {
            return false;
        }
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            return switch (blockType) {
                case BlockType.FRAMED_ELEVATED_INNER_PRISM -> ElevatedInnerPrismSkipPredicate.testAgainstElevatedInnerPrism(dirAxis, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_SLOPED_PRISM -> ElevatedInnerPrismSkipPredicate.testAgainstElevatedInnerSlopedPrism(dirAxis, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_PRISM})
    private static boolean testAgainstElevatedInnerPrism(DirectionAxis dirAxis, BlockState adjState, Direction side) {
        DirectionAxis adjDirAxis = (DirectionAxis)((Object)adjState.getValue(PropertyHolder.FACING_AXIS));
        return PrismDirs.ElevatedInnerPrism.getTriDir(dirAxis, side).isEqualTo(PrismDirs.ElevatedInnerPrism.getTriDir(adjDirAxis, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_SLOPED_PRISM})
    private static boolean testAgainstElevatedInnerSlopedPrism(DirectionAxis dirAxis, BlockState adjState, Direction side) {
        CompoundDirection adjCmpDir = (CompoundDirection)((Object)adjState.getValue(PropertyHolder.FACING_DIR));
        return PrismDirs.ElevatedInnerPrism.getTriDir(dirAxis, side).isEqualTo(PrismDirs.ElevatedInnerSlopedPrism.getTriDir(adjCmpDir, side.getOpposite()));
    }
}

