/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.PillarConnection;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;

@CullTest(value={BlockType.FRAMED_WALL})
public final class WallSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            boolean up = (Boolean)state.getValue((Property)BlockStateProperties.UP);
            return switch (blockType) {
                case BlockType.FRAMED_WALL -> WallSkipPredicate.testAgainstWall(state, up, adjState, side);
                case BlockType.FRAMED_THICK_LATTICE -> WallSkipPredicate.testAgainstThickLattice(up, adjState, side);
                case BlockType.FRAMED_PILLAR -> WallSkipPredicate.testAgainstPillar(up, adjState, side);
                case BlockType.FRAMED_HALF_PILLAR -> WallSkipPredicate.testAgainstHalfPillar(up, adjState, side);
                case BlockType.FRAMED_PYRAMID -> WallSkipPredicate.testAgainstPyramid(up, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> WallSkipPredicate.testAgainstElevatedPyramidSlab(up, adjState, side);
                case BlockType.FRAMED_UPPER_PYRAMID_SLAB -> WallSkipPredicate.testAgainstUpperPyramidSlab(up, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_WALL})
    private static boolean testAgainstWall(BlockState state, boolean up, BlockState adjState, Direction side) {
        boolean adjUp = (Boolean)adjState.getValue((Property)BlockStateProperties.UP);
        return PillarDirs.Wall.testWallArmDir(state, adjState, side) || PillarDirs.Wall.isPillarDir(up, side) && PillarDirs.Wall.isPillarDir(adjUp, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THICK_LATTICE})
    private static boolean testAgainstThickLattice(boolean up, BlockState adjState, Direction side) {
        boolean adjXAxis = (Boolean)adjState.getValue((Property)FramedProperties.X_AXIS);
        boolean adjYAxis = (Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS);
        boolean adjZAxis = (Boolean)adjState.getValue((Property)FramedProperties.Z_AXIS);
        return PillarDirs.Wall.isPillarDir(up, side) && PillarDirs.ThickLattice.isPillarDir(adjXAxis, adjYAxis, adjZAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PILLAR})
    private static boolean testAgainstPillar(boolean up, BlockState adjState, Direction side) {
        Direction.Axis adjAxis = (Direction.Axis)adjState.getValue((Property)BlockStateProperties.AXIS);
        return PillarDirs.Wall.isPillarDir(up, side) && PillarDirs.Pillar.isPillarDir(adjAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_PILLAR})
    private static boolean testAgainstHalfPillar(boolean up, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return PillarDirs.Wall.isPillarDir(up, side) && PillarDirs.HalfPillar.isPillarDir(adjDir, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PYRAMID})
    private static boolean testAgainstPyramid(boolean up, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Wall.isPillarDir(up, side) && SlopeDirs.Pyramid.isPillarDir(adjDir, adjConnection, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(boolean up, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Wall.isPillarDir(up, side) && SlopeDirs.ElevatedPyramidSlab.isPillarDir(adjDir, adjConnection, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_UPPER_PYRAMID_SLAB})
    private static boolean testAgainstUpperPyramidSlab(boolean up, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Wall.isPillarDir(up, side) && SlopeDirs.UpperPyramidSlab.isPillarDir(adjDir, adjConnection, side.getOpposite());
    }
}

