/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.CornerSlopePanelShape;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanelcorner.CornerSlopePanelShapes;

public final class InverseDoubleCornerSlopePanelShapes
implements SplitShapeGenerator {
    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return InverseDoubleCornerSlopePanelShapes.generate(states, CornerSlopePanelShapes.SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return InverseDoubleCornerSlopePanelShapes.generate(states, CornerSlopePanelShapes.OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<CornerSlopePanelShape> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(cache.get(CornerSlopePanelShape.LARGE_BOTTOM), ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.SOUTH, cache.get(CornerSlopePanelShape.SMALL_INNER_TOP)));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(cache.get(CornerSlopePanelShape.LARGE_TOP), ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.SOUTH, cache.get(CornerSlopePanelShape.SMALL_INNER_BOTTOM)));
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

